/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.test.common.util;

import io.apiman.test.common.plan.TestPlan;
import io.apiman.test.common.resttest.RestTest;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;

public class TestUtil {
    public static final TestPlan loadTestPlan(String resourcePath, ClassLoader cl) {
        try {
            URL url = cl.getResource(resourcePath);
            if (url == null) {
                throw new RuntimeException("Test Plan not found: " + resourcePath);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TestPlan.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            TestPlan plan = (TestPlan)jaxbUnmarshaller.unmarshal(url.openStream());
            return plan;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static final TestPlan loadTestPlan(File planFile) {
        try {
            if (!planFile.isFile()) {
                throw new RuntimeException("Test Plan not found: " + planFile.getCanonicalPath());
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TestPlan.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            TestPlan plan = (TestPlan)jaxbUnmarshaller.unmarshal(planFile);
            return plan;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static final RestTest loadRestTest(String resourcePath, ClassLoader cl) {
        RestTest restTest;
        InputStream is = null;
        try {
            URL url = cl.getResource(resourcePath);
            if (url == null) {
                throw new RuntimeException("Rest Test not found: " + resourcePath);
            }
            is = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            restTest = TestUtil.parseRestTest(reader);
        }
        catch (Throwable e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return restTest;
    }

    private static RestTest parseRestTest(BufferedReader reader) throws IOException {
        RestTest rval = new RestTest();
        try {
            StringBuilder builder;
            String headerValue;
            String headerName;
            String line = reader.readLine();
            String[] split = line.split(" ");
            rval.setRequestMethod(split[0]);
            rval.setRequestPath(split[1]);
            if (split.length >= 3) {
                String userpass = split[2];
                split = userpass.split("/");
                rval.setUsername(split[0]);
                rval.setPassword(split[1]);
            }
            if (!(line = reader.readLine()).trim().startsWith("----")) {
                while (line.trim().length() > 0) {
                    int idx = line.indexOf(58);
                    headerName = line.substring(0, idx).trim();
                    headerValue = line.substring(idx + 1).trim();
                    rval.getRequestHeaders().put(headerName, headerValue);
                    line = reader.readLine();
                }
                builder = new StringBuilder();
                line = reader.readLine();
                while (!line.trim().startsWith("----")) {
                    builder.append(line).append("\n");
                    line = reader.readLine();
                    line = TestUtil.doPropertyReplacement(line);
                }
                rval.setRequestPayload(builder.toString());
            }
            line = reader.readLine();
            rval.setExpectedStatusCode(new Integer(line.trim()));
            line = reader.readLine();
            while (line != null && line.trim().length() > 0) {
                int idx = line.indexOf(58);
                headerName = line.substring(0, idx).trim();
                headerValue = line.substring(idx + 1).trim();
                rval.getExpectedResponseHeaders().put(headerName, headerValue);
                line = reader.readLine();
            }
            if (line != null) {
                builder = new StringBuilder();
                line = reader.readLine();
                while (line != null && !line.trim().startsWith("----")) {
                    builder.append(line).append("\n");
                    line = reader.readLine();
                }
                rval.setExpectedResponsePayload(builder.toString());
            }
        }
        catch (Throwable t) {
            throw new IOException("Error while parsing Rest Test", t);
        }
        return rval;
    }

    public static String doPropertyReplacement(String line) {
        if (line == null) {
            return line;
        }
        String rval = line;
        int sidx = -1;
        while ((sidx = rval.indexOf("${")) != -1) {
            int eidx = rval.indexOf(125, sidx);
            String substring = rval.substring(sidx + 2, eidx);
            String propName = substring.trim();
            String propVal = System.getProperty(propName, "");
            rval = rval.replace("${" + substring + "}", propVal);
        }
        return rval;
    }
}

