/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.test.common.mock;

import io.apiman.test.common.mock.EchoResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class EchoServlet
extends HttpServlet {
    private static final long serialVersionUID = 3185466526830586555L;
    private static ObjectMapper mapper = new ObjectMapper();
    private long servletCounter = 0L;

    public static EchoResponse response(HttpServletRequest request, boolean withBody) {
        EchoResponse response = new EchoResponse();
        response.setMethod(request.getMethod());
        if (request.getQueryString() != null) {
            response.setResource(request.getRequestURI() + "?" + request.getQueryString());
        } else {
            response.setResource(request.getRequestURI());
        }
        response.setUri(request.getRequestURI());
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            String value = request.getHeader(name);
            response.getHeaders().put(name, value);
        }
        if (withBody) {
            long totalBytes = 0L;
            ServletInputStream is = null;
            try {
                is = request.getInputStream();
                MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                byte[] data = new byte[1024];
                int read = 0;
                while ((read = is.read(data)) != -1) {
                    sha1.update(data, 0, read);
                    totalBytes += (long)read;
                }
                byte[] hashBytes = sha1.digest();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < hashBytes.length; ++i) {
                    sb.append(Integer.toString((hashBytes[i] & 0xFF) + 256, 16).substring(1));
                }
                String fileHash = sb.toString();
                response.setBodyLength(totalBytes);
                response.setBodySha1(fileHash);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return response;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doEchoResponse(req, resp, false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doEchoResponse(req, resp, true);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doEchoResponse(req, resp, true);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doEchoResponse(req, resp, false);
    }

    protected void doEchoResponse(HttpServletRequest req, HttpServletResponse resp, boolean withBody) {
        EchoResponse response = EchoServlet.response(req, withBody);
        response.setCounter(++this.servletCounter);
        resp.setContentType("application/json");
        resp.setHeader("Response-Counter", response.getCounter().toString());
        try {
            mapper.writeValue((OutputStream)resp.getOutputStream(), (Object)response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
    }
}

