/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.test.suite;

import io.apiman.test.common.util.TestPlanRunner;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class FullTestSuite {
    public static void main(String[] args) throws Exception {
        String apiEndpoint = FullTestSuite.param("apiman.suite.api-endpoint", "API Endpoint", "http://localhost:8080/apiman");
        FullTestSuite.param("apiman.suite.api-username", "  Username", "admin");
        FullTestSuite.param("apiman.suite.api-password", "  Password", "admin123!");
        FullTestSuite.param("apiman.suite.gateway-config-endpoint", "Gateway Config Endpoint", "http://localhost:8080/apiman-gateway-api");
        FullTestSuite.param("apiman.suite.gateway-config-username", "  Username", "admin");
        FullTestSuite.param("apiman.suite.gateway-config-password", "  Password", "admin123!");
        String gatewayEndpoint = FullTestSuite.param("apiman.suite.gateway-endpoint", "Gateway HTTP Endpoint", "http://localhost:8080/apiman-gateway");
        FullTestSuite.param("apiman.suite.echo-endpoint", "Echo Service Endpoint", "http://localhost:8080/services/echo");
        TestPlanRunner runner = new TestPlanRunner();
        runner.runTestPlan("scripts/api-manager-testPlan.xml", FullTestSuite.class.getClassLoader(), apiEndpoint);
        runner.runTestPlan("scripts/api-gateway-testPlan.xml", FullTestSuite.class.getClassLoader(), gatewayEndpoint);
    }

    private static String param(String propertyName, String prompt, String defaultValue) throws Exception {
        if (System.getProperty(propertyName) != null) {
            return System.getProperty(propertyName);
        }
        System.out.print(prompt + " [" + defaultValue + "]: ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String input = br.readLine();
        if (input == null || input.trim().isEmpty()) {
            input = defaultValue;
        }
        System.setProperty(propertyName, input);
        return input;
    }
}

