/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.tools.devsvr.gateway;

import io.apiman.gateway.engine.components.IDataStoreComponent;
import io.apiman.gateway.engine.components.IPolicyFailureFactoryComponent;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.components.ISharedStateComponent;
import io.apiman.gateway.engine.impl.DefaultPluginRegistry;
import io.apiman.gateway.engine.impl.InMemoryDataStoreComponent;
import io.apiman.gateway.engine.impl.InMemoryRateLimiterComponent;
import io.apiman.gateway.engine.impl.InMemoryRegistry;
import io.apiman.gateway.engine.impl.InMemorySharedStateComponent;
import io.apiman.gateway.engine.policy.PolicyFactoryImpl;
import io.apiman.gateway.platforms.servlet.PolicyFailureFactoryComponent;
import io.apiman.gateway.platforms.servlet.connectors.HttpConnectorFactory;
import io.apiman.gateway.test.server.EchoServer;
import io.apiman.gateway.test.server.GatewayServer;
import java.io.File;

public class GatewayDevServer {
    private static final int GATEWAY_PORT = 6666;
    private static final int ECHO_PORT = 9001;
    private static final String APIMAN_RT_GATEWAY_SERVER_PORT = "apiman.gateway.server.port";
    private static final String ECHO_PORT_PROPERTY = "apiman.echo.server.port";

    public static void main(String[] args) throws Exception {
        int gatewayPort = GatewayDevServer.getGatewayPort();
        int echoPort = GatewayDevServer.getEchoPort();
        System.setProperty("apiman-gateway.registry", InMemoryRegistry.class.getName());
        System.setProperty("apiman-gateway.plugin-registry", DefaultPluginRegistry.class.getName());
        System.setProperty("apiman-gateway.connector-factory", HttpConnectorFactory.class.getName());
        System.setProperty("apiman-gateway.policy-factory", PolicyFactoryImpl.class.getName());
        if (System.getProperty("apiman.gateway.m2-repository-path") == null) {
            System.setProperty("apiman.gateway.m2-repository-path", new File("src/main/resources/plugin").getAbsolutePath());
        }
        System.setProperty("apiman-gateway.components." + ISharedStateComponent.class.getSimpleName(), InMemorySharedStateComponent.class.getName());
        System.setProperty("apiman-gateway.components." + IDataStoreComponent.class.getSimpleName(), InMemoryDataStoreComponent.class.getName());
        System.setProperty("apiman-gateway.components." + IRateLimiterComponent.class.getSimpleName(), InMemoryRateLimiterComponent.class.getName());
        System.setProperty("apiman-gateway.components." + IPolicyFailureFactoryComponent.class.getSimpleName(), PolicyFailureFactoryComponent.class.getName());
        GatewayServer server = new GatewayServer(gatewayPort);
        server.start();
        EchoServer echo = new EchoServer(echoPort);
        echo.start();
        while (true) {
            Thread.sleep(5000L);
        }
    }

    private static int getGatewayPort() {
        int port = 6666;
        if (System.getProperty(APIMAN_RT_GATEWAY_SERVER_PORT) != null) {
            port = new Integer(System.getProperty(APIMAN_RT_GATEWAY_SERVER_PORT));
        }
        return port;
    }

    private static int getEchoPort() {
        int port = 9001;
        if (System.getProperty(ECHO_PORT_PROPERTY) != null) {
            port = new Integer(System.getProperty(ECHO_PORT_PROPERTY));
        }
        return port;
    }
}

