/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.tools.devsvr.gateway;

import io.apiman.gateway.engine.components.IDataStoreComponent;
import io.apiman.gateway.engine.components.IPolicyFailureFactoryComponent;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.components.ISharedStateComponent;
import io.apiman.gateway.engine.es.ESMetrics;
import io.apiman.gateway.engine.impl.DefaultPluginRegistry;
import io.apiman.gateway.engine.impl.InMemoryDataStoreComponent;
import io.apiman.gateway.engine.impl.InMemoryMetrics;
import io.apiman.gateway.engine.impl.InMemoryRateLimiterComponent;
import io.apiman.gateway.engine.impl.InMemoryRegistry;
import io.apiman.gateway.engine.impl.InMemorySharedStateComponent;
import io.apiman.gateway.engine.policy.PolicyFactoryImpl;
import io.apiman.gateway.platforms.servlet.PolicyFailureFactoryComponent;
import io.apiman.gateway.platforms.servlet.connectors.HttpConnectorFactory;
import io.apiman.gateway.test.server.EchoServer;
import io.apiman.gateway.test.server.GatewayServer;
import java.io.File;

public class GatewayDevServer {
    private static final int GATEWAY_PORT = 6666;
    private static final int ECHO_PORT = 9001;
    private static final String APIMAN_RT_GATEWAY_SERVER_PORT = "apiman.gateway.server.port";
    private static final String ECHO_PORT_PROPERTY = "apiman.echo.server.port";
    private static boolean enableESMetrics = false;

    public static void main(String[] args) throws Exception {
        int gatewayPort = GatewayDevServer.getGatewayPort();
        int echoPort = GatewayDevServer.getEchoPort();
        enableESMetrics = "true".equals(System.getProperty("apiman-test.es-metrics", "false"));
        System.setProperty("apiman-gateway.registry", InMemoryRegistry.class.getName());
        System.setProperty("apiman-gateway.plugin-registry", DefaultPluginRegistry.class.getName());
        System.setProperty("apiman-gateway.connector-factory", HttpConnectorFactory.class.getName());
        System.setProperty("apiman-gateway.policy-factory", PolicyFactoryImpl.class.getName());
        System.setProperty("apiman-gateway.metrics", InMemoryMetrics.class.getName());
        if (System.getProperty("apiman.gateway.m2-repository-path") == null) {
            System.setProperty("apiman.gateway.m2-repository-path", new File("src/main/resources/plugin").getAbsolutePath());
        }
        if (enableESMetrics) {
            System.setProperty("apiman-gateway.metrics", ESMetrics.class.getName());
            System.setProperty("apiman-gateway.metrics.client.type", "jest");
            System.setProperty("apiman-gateway.metrics.client.cluster-name", System.getProperty("apiman-test.es-metrics.cluster-name", "apiman"));
            System.setProperty("apiman-gateway.metrics.client.host", System.getProperty("apiman-test.es-metrics.host", "localhost"));
            System.setProperty("apiman-gateway.metrics.client.port", System.getProperty("apiman-test.es-metrics.port", "9200"));
            System.setProperty("apiman-gateway.metrics.client.index", System.getProperty("apiman-test.es-metrics.index", "apiman_metrics"));
        }
        System.setProperty("apiman-gateway.components." + ISharedStateComponent.class.getSimpleName(), InMemorySharedStateComponent.class.getName());
        System.setProperty("apiman-gateway.components." + IDataStoreComponent.class.getSimpleName(), InMemoryDataStoreComponent.class.getName());
        System.setProperty("apiman-gateway.components." + IRateLimiterComponent.class.getSimpleName(), InMemoryRateLimiterComponent.class.getName());
        System.setProperty("apiman-gateway.components." + IPolicyFailureFactoryComponent.class.getSimpleName(), PolicyFailureFactoryComponent.class.getName());
        GatewayServer server = new GatewayServer(gatewayPort);
        server.start();
        EchoServer echo = new EchoServer(echoPort);
        echo.start();
        while (true) {
            Thread.sleep(5000L);
        }
    }

    private static int getGatewayPort() {
        int port = 6666;
        if (System.getProperty(APIMAN_RT_GATEWAY_SERVER_PORT) != null) {
            port = new Integer(System.getProperty(APIMAN_RT_GATEWAY_SERVER_PORT));
        }
        return port;
    }

    private static int getEchoPort() {
        int port = 9001;
        if (System.getProperty(ECHO_PORT_PROPERTY) != null) {
            port = new Integer(System.getProperty(ECHO_PORT_PROPERTY));
        }
        return port;
    }
}

