/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.tools.i18n;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class TemplateScanner {
    private static final Set<String> TRANSLATABLE_ATTRIBUTES = new HashSet<String>();

    public static void main(String[] args) throws IOException {
        File outputFile;
        File outputDir;
        File templateDir;
        if (args == null || args.length != 1) {
            System.out.println("Template directory not provided (no path provided).");
            System.exit(1);
        }
        if (!(templateDir = new File(args[0])).isDirectory()) {
            System.out.println("Template directory not provided (provided path is not a directory).");
            System.exit(1);
        }
        if (!new File(templateDir, "dash.html").isFile()) {
            System.out.println("Template directory not provided (dash.html not found).");
            System.exit(1);
        }
        if (!(outputDir = new File(templateDir, "../../../../../../tools/i18n/target")).isDirectory()) {
            System.out.println("Output directory not found: " + outputDir);
            System.exit(1);
        }
        if ((outputFile = new File(outputDir, "scanner-messages.properties")).isFile() && !outputFile.delete()) {
            System.out.println("Couldn't delete the old messages.properties: " + outputFile);
            System.exit(1);
        }
        System.out.println("Starting scan.");
        System.out.println("Scanning template directory: " + templateDir.getAbsolutePath());
        String[] extensions = new String[]{"html", "include"};
        Collection files = FileUtils.listFiles((File)templateDir, (String[])extensions, (boolean)true);
        TreeMap<String, String> strings = new TreeMap<String, String>();
        for (File file : files) {
            System.out.println("\tScanning file: " + file);
            TemplateScanner.scanFile(file, strings);
        }
        TemplateScanner.outputMessages(strings, outputFile);
        System.out.println("Scan complete.  Scanned " + files.size() + " files and discovered " + strings.size() + " translation strings.");
    }

    private static void scanFile(File file, TreeMap<String, String> strings) throws IOException {
        Document doc = Jsoup.parse((File)file, (String)"UTF-8");
        Elements elements = doc.select("*[apiman-i18n-key]");
        for (Element element : elements) {
            String elementVal;
            String i18nKey = element.attr("apiman-i18n-key");
            boolean isNecessary = false;
            if (strings.containsKey(i18nKey)) {
                if (TemplateScanner.hasNoChildren(element)) {
                    String currentValue;
                    isNecessary = true;
                    elementVal = element.text();
                    if (elementVal.trim().length() > 0 && !elementVal.contains("{{") && !(currentValue = strings.get(i18nKey)).equals(elementVal)) {
                        throw new IOException("Duplicate i18n key found with different default values.  Key=" + i18nKey + "  Value1=" + elementVal + "  Value2=" + currentValue);
                    }
                }
            } else if (TemplateScanner.hasNoChildren(element) && (elementVal = element.text()).trim().length() > 0 && !elementVal.contains("{{")) {
                isNecessary = true;
                strings.put(i18nKey, elementVal);
            }
            for (String tattr : TRANSLATABLE_ATTRIBUTES) {
                String attrValue;
                if (!element.hasAttr(tattr) || (attrValue = element.attr(tattr)).contains("{{")) continue;
                String attrI18nKey = i18nKey + '.' + tattr;
                String currentAttrValue = strings.get(attrI18nKey);
                if (currentAttrValue == null) {
                    isNecessary = true;
                    strings.put(attrI18nKey, attrValue);
                    continue;
                }
                if (!currentAttrValue.equals(attrValue)) {
                    throw new IOException("Duplicate i18n key found with different default values (for attribute '" + tattr + "').  Key=" + attrI18nKey + "  Value1=" + attrValue + "  Value2=" + currentAttrValue);
                }
                isNecessary = true;
            }
            if (isNecessary) continue;
            throw new IOException("Detected an unnecessary apiman-i18n-key attribute in file '" + file.getName() + "' on element: " + element);
        }
        elements = doc.select("*");
        for (Element element : elements) {
            String value;
            if (element.hasAttr("apiman-i18n-key") || element.hasAttr("apiman-i18n-skip") || !TemplateScanner.hasNoChildren(element) || (value = element.text()) == null || value.trim().length() <= 0 || value.contains("{{")) continue;
            throw new IOException("Found an element in '" + file.getName() + "' that should be translated:  " + element);
        }
        for (String tattr : TRANSLATABLE_ATTRIBUTES) {
            elements = doc.select("*[" + tattr + "]");
            for (Element element : elements) {
                if (element.hasAttr("apiman-i18n-key") || element.hasAttr("apiman-i18n-skip") || element.attr(tattr).contains("{{")) continue;
                throw new IOException("In template '" + file.getName() + "', found an element with a '" + tattr + "' attribute but missing 'apiman-i18n-key': " + element);
            }
        }
    }

    private static boolean hasNoChildren(Element element) {
        List childNodes = element.childNodes();
        for (Node node : childNodes) {
            if (!(node instanceof Element)) continue;
            return false;
        }
        return true;
    }

    private static void outputMessages(TreeMap<String, String> strings, File outputFile) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(new FileOutputStream(outputFile));
        for (Map.Entry<String, String> entry : strings.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            writer.append(key);
            writer.append('=');
            writer.append(val);
            writer.append("\n");
        }
        writer.flush();
        writer.close();
    }

    static {
        TRANSLATABLE_ATTRIBUTES.add("title");
        TRANSLATABLE_ATTRIBUTES.add("placeholder");
    }
}

