/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.plugins.jsonp_policy;

import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.ServiceResponse;
import io.apiman.gateway.engine.components.IBufferFactoryComponent;
import io.apiman.gateway.engine.io.IReadWriteStream;
import io.apiman.gateway.engine.policies.AbstractMappedPolicy;
import io.apiman.gateway.engine.policy.IDataPolicy;
import io.apiman.gateway.engine.policy.IPolicyChain;
import io.apiman.gateway.engine.policy.IPolicyContext;
import io.apiman.plugins.jsonp_policy.beans.JsonpConfigBean;

public class JsonpPolicy
extends AbstractMappedPolicy<JsonpConfigBean>
implements IDataPolicy {
    private static final String OPEN_PARENTHESES = "(";
    private static final String CLOSE_PARENTHESES = ")";
    static final String CALLBACK_FUNCTION_NAME = "callbackFunctionName";

    protected Class<JsonpConfigBean> getConfigurationClass() {
        return JsonpConfigBean.class;
    }

    protected void doApply(ServiceRequest request, IPolicyContext context, JsonpConfigBean config, IPolicyChain<ServiceRequest> chain) {
        String callbackFunctionName;
        String callbackParamName = config.getCallbackParamName();
        if (callbackParamName != null && (callbackFunctionName = (String)request.getQueryParams().remove(callbackParamName)) != null) {
            context.setAttribute(CALLBACK_FUNCTION_NAME, (Object)callbackFunctionName);
        }
        super.doApply(request, context, (Object)config, chain);
    }

    public IReadWriteStream<ServiceRequest> getRequestDataHandler(ServiceRequest request, IPolicyContext context) {
        return null;
    }

    public IReadWriteStream<ServiceResponse> getResponseDataHandler(ServiceResponse response, IPolicyContext context) {
        String callbackFunctionName = (String)context.getAttribute(CALLBACK_FUNCTION_NAME, null);
        if (callbackFunctionName != null) {
            response.getHeaders().put("Content-Type", "application/javascript");
            IBufferFactoryComponent bufferFactory = (IBufferFactoryComponent)context.getComponent(IBufferFactoryComponent.class);
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        return null;
    }
}

