/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.plugins.jsonp_policy.http;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentType {
    private static final Pattern DELIMITING_PATTERN = Pattern.compile(";");
    private static final Pattern TYPE_SUBTYPE_PATTERN = Pattern.compile("([^/]+/[^/]+)");
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("([^=]+)=([^=]+)");
    private String typeSubtype;
    private SortedMap<String, String> parameters;

    public ContentType(String str) {
        String[] parts = DELIMITING_PATTERN.split(str);
        Matcher matcher = TYPE_SUBTYPE_PATTERN.matcher(parts[0]);
        if (matcher.find()) {
            this.typeSubtype = matcher.group(1).trim();
        }
        if (parts.length > 1) {
            this.parameters = new TreeMap();
            for (int i = 1; i < parts.length; ++i) {
                matcher = PARAMETER_PATTERN.matcher(parts[i]);
                if (!matcher.find()) continue;
                String key = matcher.group(1).trim();
                String value = matcher.group(2).trim();
                this.parameters.put(key, value);
            }
        }
    }

    public String getTypeSubtype() {
        return this.typeSubtype;
    }

    public void setTypeSubtype(String typeSubtype) {
        this.typeSubtype = typeSubtype;
    }

    public String getCharset() {
        return this.parameters != null ? (String)this.parameters.get("charset") : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.typeSubtype);
        if (this.parameters != null) {
            for (Map.Entry entry : this.parameters.entrySet()) {
                sb.append("; ").append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
        }
        return sb.toString();
    }
}

