/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.plugins.jsonp_policy.http;

import io.apiman.plugins.jsonp_policy.http.ContentType;
import java.util.Map;

public class HttpHeaders {
    private static final String CONTENT_TYPE = "Content-Type";
    private final Map<String, String> headers;

    public HttpHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getCharsetFromContentType(String defaultCharset) {
        String charset = null;
        String contentTypeStr = (String)this.headers.get(CONTENT_TYPE);
        if (contentTypeStr != null) {
            charset = new ContentType(contentTypeStr).getCharset();
        }
        return charset != null ? charset : defaultCharset;
    }

    public void setContentType(String typeSubtype) {
        String contentTypeStr = (String)this.headers.get(CONTENT_TYPE);
        if (contentTypeStr != null) {
            ContentType contentType = new ContentType(contentTypeStr);
            contentType.setTypeSubtype(typeSubtype);
            this.headers.put(CONTENT_TYPE, contentType.toString());
        } else {
            this.headers.put(CONTENT_TYPE, typeSubtype);
        }
    }
}

