/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types.http.response;

import io.apimatic.core.utilities.CoreHelper;
import io.apimatic.coreinterfaces.http.HttpHeaders;
import io.apimatic.coreinterfaces.http.response.DynamicType;
import io.apimatic.coreinterfaces.http.response.Response;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Map;

public class Dynamic
implements DynamicType {
    private Response response;

    public Dynamic(Response responseBody) {
        this.response = responseBody;
    }

    public <T> T parse(Class<T> cls) throws ParseException {
        try {
            return CoreHelper.deserialize(this.getResponseString(), cls);
        }
        catch (Exception e) {
            throw new ParseException("Could not deserialize dynamic content as given type", 0);
        }
    }

    public boolean parseAsBoolean() throws ParseException {
        return this.parse(Boolean.class);
    }

    public byte parseAsByte() throws ParseException {
        return this.parse(Byte.class);
    }

    public char parseAsCharacter() throws ParseException {
        return this.parse(Character.class).charValue();
    }

    public float parseAsFloat() throws ParseException {
        return this.parse(Float.class).floatValue();
    }

    public int parseAsInteger() throws ParseException {
        return this.parse(Integer.class);
    }

    public long parseAsLong() throws ParseException {
        return this.parse(Long.class);
    }

    public short parseAsShort() throws ParseException {
        return this.parse(Short.class);
    }

    public double parseAsDouble() throws ParseException {
        return this.parse(Double.class);
    }

    public String parseAsString() throws ParseException {
        try {
            return this.getResponseString();
        }
        catch (Throwable e) {
            throw new ParseException("Could not deserialize dynamic content as given type", 0);
        }
    }

    public Map<String, Object> parseAsDictionary() throws ParseException {
        try {
            return CoreHelper.deserialize(this.getResponseString());
        }
        catch (IOException e) {
            throw new ParseException("Could not deserialize dynamic content as given type", 0);
        }
    }

    public InputStream getRawBody() {
        return this.response.getRawBody();
    }

    public HttpHeaders getHeaders() {
        return this.response.getHeaders();
    }

    private String getResponseString() {
        return this.response.getBody();
    }
}

