/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core;

import io.apimatic.core.utilities.CoreHelper;
import io.apimatic.coreinterfaces.authentication.Authentication;
import io.apimatic.coreinterfaces.compatibility.CompatibilityFactory;
import io.apimatic.coreinterfaces.http.Callback;
import io.apimatic.coreinterfaces.http.HttpClient;
import io.apimatic.coreinterfaces.http.HttpHeaders;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class GlobalConfiguration {
    private CompatibilityFactory compatibilityFactory;
    private String userAgent;
    private Map<String, String> userAgentConfig;
    private Map<String, Authentication> authentications;
    private Callback callback;
    private HttpClient httpClient;
    private Map<String, List<String>> globalHeaders;
    private HttpHeaders additionalHeaders;
    private Function<String, String> baseUri;

    private GlobalConfiguration(CompatibilityFactory compatibilityFactory, String userAgent, Map<String, String> userAgentConfig, Map<String, Authentication> authentications, Callback callback, HttpClient httpClient, Map<String, List<String>> globalHeaders, HttpHeaders additionalHeaders, Function<String, String> baseUri) {
        this.compatibilityFactory = compatibilityFactory;
        this.userAgent = userAgent;
        this.userAgentConfig = userAgentConfig;
        this.authentications = authentications;
        this.callback = callback;
        this.httpClient = httpClient;
        this.globalHeaders = globalHeaders != null ? globalHeaders : new HashMap();
        this.additionalHeaders = additionalHeaders;
        this.baseUri = baseUri;
        if (this.userAgent != null) {
            this.userAgent = CoreHelper.updateUserAgent(userAgent, userAgentConfig);
            this.globalHeaders.put("user-agent", Arrays.asList(this.userAgent));
        }
    }

    public CompatibilityFactory getCompatibilityFactory() {
        return this.compatibilityFactory;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Map<String, String> getUserAgentConfig() {
        return this.userAgentConfig;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Callback getHttpCallback() {
        return this.callback;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Map<String, List<String>> getGlobalHeaders() {
        return this.globalHeaders;
    }

    public HttpHeaders getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public Function<String, String> getBaseUri() {
        return this.baseUri;
    }

    public static class Builder {
        private CompatibilityFactory compatibilityFactory;
        private String userAgent;
        private Map<String, String> userAgentConfig;
        private Map<String, Authentication> authentications;
        private Callback callback;
        private HttpClient httpClient;
        private Map<String, List<String>> globalHeaders = new HashMap<String, List<String>>();
        private HttpHeaders additionalheaders;
        private Function<String, String> baseUri;

        public Builder compatibilityFactory(CompatibilityFactory compatibilityFactory) {
            this.compatibilityFactory = compatibilityFactory;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder userAgentConfig(Map<String, String> userAgentConfig) {
            this.userAgentConfig = userAgentConfig;
            return this;
        }

        public Builder authentication(Map<String, Authentication> authentications) {
            this.authentications = authentications;
            return this;
        }

        public Builder callback(Callback callback) {
            this.callback = callback;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder globalHeader(String key, String value) {
            if (this.globalHeaders.containsKey(key)) {
                this.globalHeaders.get(key).add(value);
            } else {
                ArrayList<String> headerValues = new ArrayList<String>();
                headerValues.add(value);
                this.globalHeaders.put(key, headerValues);
            }
            return this;
        }

        public Builder additionalHeaders(HttpHeaders additionalHeaders) {
            this.additionalheaders = additionalHeaders;
            return this;
        }

        public Builder baseUri(Function<String, String> baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public GlobalConfiguration build() {
            return new GlobalConfiguration(this.compatibilityFactory, this.userAgent, this.userAgentConfig, this.authentications, this.callback, this.httpClient, this.globalHeaders, this.additionalheaders, this.baseUri);
        }
    }
}

