/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.authentication;

import io.apimatic.coreinterfaces.authentication.Authentication;
import io.apimatic.coreinterfaces.http.request.Request;
import java.util.HashMap;
import java.util.Map;

public class QueryAuth
implements Authentication {
    private Map<String, String> authParams = new HashMap<String, String>();

    public QueryAuth(Map<String, String> authParams) {
        this.authParams = authParams;
    }

    public Request apply(Request httpRequest) {
        this.authParams.forEach((key, value) -> httpRequest.addQueryParameter(key, value));
        return httpRequest;
    }

    public void validate() {
        this.authParams.forEach((key, value) -> {
            if (key == null || value == null) {
                throw new IllegalStateException("Auth key or value cannot be null.");
            }
        });
    }
}

