/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.utilities;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.apimatic.core.utilities.DateHelper;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class ZonedDateTimeHelper
extends DateHelper {
    private static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z").withZone(ZoneId.of("GMT"));

    public static ZonedDateTime fromUnixTimestamp(Long date) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(date), ZoneId.systemDefault());
    }

    public static ZonedDateTime fromUnixTimestamp(String date) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(Long.parseLong(date)), ZoneId.systemDefault());
    }

    public static String toUnixTimestamp(ZonedDateTime value) {
        return value == null ? null : Long.toString(ZonedDateTimeHelper.toUnixTimestampLong(value));
    }

    public static List<String> toUnixTimestamp(List<ZonedDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (ZonedDateTime value : values) {
            valuesAsString.add(ZonedDateTimeHelper.toUnixTimestamp(value));
        }
        return valuesAsString;
    }

    public static Map<String, String> toUnixTimestamp(Map<String, ZonedDateTime> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> valuesAsString = new HashMap<String, String>();
        for (Map.Entry<String, ZonedDateTime> value : values.entrySet()) {
            valuesAsString.put(value.getKey(), ZonedDateTimeHelper.toUnixTimestamp(value.getValue()));
        }
        return valuesAsString;
    }

    public static List<Map<String, String>> toArrayOfMapOfUnixTimestamp(List<Map<String, ZonedDateTime>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Map<String, String>> valuesAsString = new ArrayList<Map<String, String>>();
        for (Map<String, ZonedDateTime> value : values) {
            valuesAsString.add(ZonedDateTimeHelper.toUnixTimestamp(value));
        }
        return valuesAsString;
    }

    public static Long toUnixTimestampLong(ZonedDateTime value) {
        return value == null ? null : Long.valueOf(value.toEpochSecond());
    }

    public static List<Long> toUnixTimestampLong(List<ZonedDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Long> valuesAsLong = new ArrayList<Long>();
        for (ZonedDateTime value : values) {
            valuesAsLong.add(ZonedDateTimeHelper.toUnixTimestampLong(value));
        }
        return valuesAsLong;
    }

    public static Map<String, Long> toUnixTimestampLong(Map<String, ZonedDateTime> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, Long> valuesAsLong = new HashMap<String, Long>();
        for (Map.Entry<String, ZonedDateTime> value : values.entrySet()) {
            valuesAsLong.put(value.getKey(), ZonedDateTimeHelper.toUnixTimestampLong(value.getValue()));
        }
        return valuesAsLong;
    }

    public static List<Map<String, Long>> toArrayOfMapOfUnixTimestampLong(List<Map<String, ZonedDateTime>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Map<String, Long>> valuesAsLong = new ArrayList<Map<String, Long>>();
        for (Map<String, ZonedDateTime> value : values) {
            valuesAsLong.add(ZonedDateTimeHelper.toUnixTimestampLong(value));
        }
        return valuesAsLong;
    }

    public static ZonedDateTime fromRfc1123DateTime(String date) {
        return ZonedDateTime.parse(date, RFC1123_DATE_TIME_FORMATTER);
    }

    public static String toRfc1123DateTime(ZonedDateTime value) {
        return value == null ? null : RFC1123_DATE_TIME_FORMATTER.format(value);
    }

    public static List<String> toRfc1123DateTime(List<ZonedDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (ZonedDateTime value : values) {
            valuesAsString.add(ZonedDateTimeHelper.toRfc1123DateTime(value));
        }
        return valuesAsString;
    }

    public static Map<String, String> toRfc1123DateTime(Map<String, ZonedDateTime> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> valuesAsString = new HashMap<String, String>();
        for (Map.Entry<String, ZonedDateTime> value : values.entrySet()) {
            valuesAsString.put(value.getKey(), ZonedDateTimeHelper.toRfc1123DateTime(value.getValue()));
        }
        return valuesAsString;
    }

    public static List<Map<String, String>> toArrayOfMapOfRfc1123DateTime(List<Map<String, ZonedDateTime>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Map<String, String>> valuesAsString = new ArrayList<Map<String, String>>();
        for (Map<String, ZonedDateTime> value : values) {
            valuesAsString.add(ZonedDateTimeHelper.toRfc1123DateTime(value));
        }
        return valuesAsString;
    }

    public static ZonedDateTime fromRfc8601DateTime(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME);
    }

    public static String toRfc8601DateTime(ZonedDateTime value) {
        return value == null ? null : value.toString();
    }

    public static List<String> toRfc8601DateTime(List<ZonedDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (ZonedDateTime value : values) {
            valuesAsString.add(ZonedDateTimeHelper.toRfc8601DateTime(value));
        }
        return valuesAsString;
    }

    public static Map<String, String> toRfc8601DateTime(Map<String, ZonedDateTime> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> valuesAsString = new HashMap<String, String>();
        for (Map.Entry<String, ZonedDateTime> value : values.entrySet()) {
            valuesAsString.put(value.getKey(), ZonedDateTimeHelper.toRfc8601DateTime(value.getValue()));
        }
        return valuesAsString;
    }

    public static List<Map<String, String>> toArrayOfMapOfRfc8601DateTime(List<Map<String, ZonedDateTime>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Map<String, String>> valuesAsString = new ArrayList<Map<String, String>>();
        for (Map<String, ZonedDateTime> value : values) {
            valuesAsString.add(ZonedDateTimeHelper.toRfc8601DateTime(value));
        }
        return valuesAsString;
    }

    public static class UnixTimestampAdapter
    extends XmlAdapter<String, ZonedDateTime> {
        public String marshal(ZonedDateTime dateTime) {
            return ZonedDateTimeHelper.toUnixTimestamp(dateTime);
        }

        public ZonedDateTime unmarshal(String dateTime) {
            return ZonedDateTimeHelper.fromUnixTimestamp(dateTime);
        }
    }

    public static class Rfc8601DateTimeAdapter
    extends XmlAdapter<String, ZonedDateTime> {
        public String marshal(ZonedDateTime dateTime) {
            return ZonedDateTimeHelper.toRfc8601DateTime(dateTime);
        }

        public ZonedDateTime unmarshal(String dateTime) {
            return ZonedDateTimeHelper.fromRfc8601DateTime(dateTime);
        }
    }

    public static class Rfc1123DateTimeAdapter
    extends XmlAdapter<String, ZonedDateTime> {
        public String marshal(ZonedDateTime dateTime) {
            return ZonedDateTimeHelper.toRfc1123DateTime(dateTime);
        }

        public ZonedDateTime unmarshal(String dateTime) {
            return ZonedDateTimeHelper.fromRfc1123DateTime(dateTime);
        }
    }

    public static class Rfc8601DateTimeSerializer
    extends JsonSerializer<ZonedDateTime> {
        public void serialize(ZonedDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(ZonedDateTimeHelper.toRfc8601DateTime(value));
        }
    }

    public static class Rfc8601DateTimeDeserializer
    extends JsonDeserializer<ZonedDateTime> {
        public ZonedDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return ZonedDateTimeHelper.fromRfc8601DateTime(jp.getValueAsString());
        }
    }

    public static class Rfc1123DateTimeSerializer
    extends JsonSerializer<ZonedDateTime> {
        public void serialize(ZonedDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(ZonedDateTimeHelper.toRfc1123DateTime(value));
        }
    }

    public static class Rfc1123DateTimeDeserializer
    extends JsonDeserializer<ZonedDateTime> {
        public ZonedDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return ZonedDateTimeHelper.fromRfc1123DateTime(jp.getValueAsString());
        }
    }

    public static class UnixTimestampSerializer
    extends JsonSerializer<ZonedDateTime> {
        public void serialize(ZonedDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)ZonedDateTimeHelper.toUnixTimestampLong(value));
        }
    }

    public static class UnixTimestampDeserializer
    extends JsonDeserializer<ZonedDateTime> {
        public ZonedDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return ZonedDateTimeHelper.fromUnixTimestamp(jp.getValueAsString());
        }
    }
}

