/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.utilities;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class DateHelper {
    protected DateHelper() {
    }

    public static LocalDate fromSimpleDate(String date) {
        return LocalDate.parse(date);
    }

    public static String toSimpleDate(LocalDate value) {
        return value == null ? null : value.toString();
    }

    public static List<String> toSimpleDate(List<LocalDate> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (LocalDate value : values) {
            valuesAsString.add(DateHelper.toSimpleDate(value));
        }
        return valuesAsString;
    }

    public static Map<String, String> toSimpleDate(Map<String, LocalDate> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> valuesAsString = new HashMap<String, String>();
        for (Map.Entry<String, LocalDate> value : values.entrySet()) {
            valuesAsString.put(value.getKey(), DateHelper.toSimpleDate(value.getValue()));
        }
        return valuesAsString;
    }

    public static List<Map<String, String>> toArrayOfMapOfSimpleDate(List<Map<String, LocalDate>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Map<String, String>> valuesAsString = new ArrayList<Map<String, String>>();
        for (Map<String, LocalDate> value : values) {
            valuesAsString.add(DateHelper.toSimpleDate(value));
        }
        return valuesAsString;
    }

    public static class SimpleAdapter
    extends XmlAdapter<String, LocalDate> {
        public String marshal(LocalDate date) {
            return date.toString();
        }

        public LocalDate unmarshal(String date) {
            return LocalDate.parse(date);
        }
    }

    public static class SimpleDateSerializer
    extends JsonSerializer<LocalDate> {
        public void serialize(LocalDate value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(DateHelper.toSimpleDate(value));
        }
    }

    public static class SimpleDateDeserializer
    extends JsonDeserializer<LocalDate> {
        public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DateHelper.fromSimpleDate(jp.getValueAsString());
        }
    }
}

