/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core;

import io.apimatic.core.GlobalConfiguration;
import io.apimatic.core.HttpRequest;
import io.apimatic.core.ResponseHandler;
import io.apimatic.core.configurations.http.request.EndpointConfiguration;
import io.apimatic.core.logger.SdkLoggerFactory;
import io.apimatic.core.request.async.AsyncExecutor;
import io.apimatic.core.types.CoreApiException;
import io.apimatic.coreinterfaces.http.request.Request;
import io.apimatic.coreinterfaces.http.request.configuration.CoreEndpointConfiguration;
import io.apimatic.coreinterfaces.http.response.Response;
import io.apimatic.coreinterfaces.logger.ApiLogger;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public final class ApiCall<ResponseType, ExceptionType extends CoreApiException> {
    private final GlobalConfiguration globalConfig;
    private final Request request;
    private final ResponseHandler<ResponseType, ExceptionType> responseHandler;
    private final CoreEndpointConfiguration endpointConfiguration;
    private final ApiLogger apiLogger;

    private ApiCall(GlobalConfiguration globalConfig, Request coreHttpRequest, ResponseHandler<ResponseType, ExceptionType> responseHandler, CoreEndpointConfiguration coreEndpointConfiguration) {
        this.globalConfig = globalConfig;
        this.request = coreHttpRequest;
        this.responseHandler = responseHandler;
        this.endpointConfiguration = coreEndpointConfiguration;
        this.apiLogger = SdkLoggerFactory.getLogger(globalConfig.getLoggingConfiguration());
    }

    public ResponseType execute() throws IOException, ExceptionType {
        this.apiLogger.logRequest(this.request);
        Response httpResponse = this.globalConfig.getHttpClient().execute(this.request, this.endpointConfiguration);
        this.apiLogger.logResponse(httpResponse);
        return this.responseHandler.handle(this.request, httpResponse, this.globalConfig, this.endpointConfiguration);
    }

    public CompletableFuture<ResponseType> executeAsync() {
        return AsyncExecutor.makeHttpCallAsync(() -> this.request, request -> this.globalConfig.getHttpClient().executeAsync(request, this.endpointConfiguration), (httpRequest, httpResponse) -> this.responseHandler.handle(httpRequest, httpResponse, this.globalConfig, this.endpointConfiguration), this.apiLogger);
    }

    public static class Builder<ResponseType, ExceptionType extends CoreApiException> {
        private GlobalConfiguration globalConfig;
        private HttpRequest.Builder requestBuilder = new HttpRequest.Builder();
        private ResponseHandler.Builder<ResponseType, ExceptionType> responseHandlerBuilder = new ResponseHandler.Builder();
        private EndpointConfiguration.Builder endpointConfigurationBuilder = new EndpointConfiguration.Builder();

        public Builder<ResponseType, ExceptionType> globalConfig(GlobalConfiguration globalConfig) {
            this.globalConfig = globalConfig;
            return this;
        }

        public Builder<ResponseType, ExceptionType> requestBuilder(Consumer<HttpRequest.Builder> action) {
            this.requestBuilder = new HttpRequest.Builder();
            action.accept(this.requestBuilder);
            return this;
        }

        public Builder<ResponseType, ExceptionType> responseHandler(Consumer<ResponseHandler.Builder<ResponseType, ExceptionType>> action) {
            this.responseHandlerBuilder = new ResponseHandler.Builder();
            action.accept(this.responseHandlerBuilder);
            return this;
        }

        public Builder<ResponseType, ExceptionType> endpointConfiguration(Consumer<EndpointConfiguration.Builder> action) {
            this.endpointConfigurationBuilder = new EndpointConfiguration.Builder();
            action.accept(this.endpointConfigurationBuilder);
            return this;
        }

        public ApiCall<ResponseType, ExceptionType> build() throws IOException {
            return new ApiCall(this.globalConfig, this.requestBuilder.build(this.globalConfig), this.responseHandlerBuilder.build(), this.endpointConfigurationBuilder.build());
        }
    }
}

