/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core;

import io.apimatic.core.ErrorCase;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.core.types.CoreApiException;
import io.apimatic.core.utilities.CoreHelper;
import io.apimatic.coreinterfaces.compatibility.CompatibilityFactory;
import io.apimatic.coreinterfaces.http.Context;
import io.apimatic.coreinterfaces.http.request.Request;
import io.apimatic.coreinterfaces.http.request.ResponseClassType;
import io.apimatic.coreinterfaces.http.request.configuration.CoreEndpointConfiguration;
import io.apimatic.coreinterfaces.http.response.Response;
import io.apimatic.coreinterfaces.type.functional.ContextInitializer;
import io.apimatic.coreinterfaces.type.functional.Deserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ResponseHandler<ResponseType, ExceptionType extends CoreApiException> {
    private static final int NOT_FOUND_STATUS_CODE = 404;
    private static final int MIN_SUCCESS_CODE = 200;
    private static final int MAX_SUCCESS_CODE = 208;
    private final Map<String, ErrorCase<ExceptionType>> localErrorCases;
    private final Map<String, ErrorCase<ExceptionType>> globalErrorCases;
    private final Deserializer<ResponseType> deserializer;
    private final Deserializer<?> intermediateDeserializer;
    private final ResponseClassType responseClassType;
    private final ContextInitializer<ResponseType> contextInitializer;
    private final boolean isNullify404Enabled;
    private final boolean isNullableResponseType;

    private ResponseHandler(Map<String, ErrorCase<ExceptionType>> localErrorCases, Map<String, ErrorCase<ExceptionType>> globalErrorCases, Deserializer<ResponseType> deserializer, Deserializer<?> intermediateDeserializer, ResponseClassType responseClassType, ContextInitializer<ResponseType> contextInitializer, boolean isNullify404Enabled, boolean isNullableResponseType) {
        this.localErrorCases = localErrorCases;
        this.globalErrorCases = globalErrorCases;
        this.deserializer = deserializer;
        this.intermediateDeserializer = intermediateDeserializer;
        this.responseClassType = responseClassType;
        this.contextInitializer = contextInitializer;
        this.isNullify404Enabled = isNullify404Enabled;
        this.isNullableResponseType = isNullableResponseType;
    }

    public ResponseType handle(Request httpRequest, Response httpResponse, GlobalConfiguration globalConfiguration, CoreEndpointConfiguration endpointConfiguration) throws IOException, ExceptionType {
        int responseCode;
        Context httpContext = globalConfiguration.getCompatibilityFactory().createHttpContext(httpRequest, httpResponse);
        if (globalConfiguration.getHttpCallback() != null) {
            globalConfiguration.getHttpCallback().onAfterResponse(httpContext);
        }
        if (this.isNullify404Enabled && (responseCode = httpContext.getResponse().getStatusCode()) == 404) {
            return null;
        }
        this.validateResponse(httpContext);
        Object result = this.applyDeserializer(this.deserializer, httpResponse);
        result = this.applyContextInitializer(this.contextInitializer, httpContext, result);
        if (endpointConfiguration.hasBinaryResponse()) {
            result = httpResponse.getRawBody();
        }
        if (this.responseClassType != null) {
            return this.createResponseClassType(httpResponse, globalConfiguration, endpointConfiguration.hasBinaryResponse());
        }
        return result;
    }

    private ResponseType applyContextInitializer(ContextInitializer<ResponseType> contextInitializer, Context httpContext, ResponseType result) throws IOException {
        if (contextInitializer != null && this.deserializer != null) {
            result = contextInitializer.apply(httpContext, result);
        }
        return result;
    }

    private <T> T applyDeserializer(Deserializer<T> deserializer, Response httpResponse) throws IOException {
        if (this.isNullableResponseType && CoreHelper.isNullOrWhiteSpace(httpResponse.getBody())) {
            return null;
        }
        Object result = null;
        if (deserializer != null) {
            result = deserializer.apply(httpResponse.getBody());
        }
        return (T)result;
    }

    private <T> ResponseType createResponseClassType(Response httpResponse, GlobalConfiguration coreConfig, boolean hasBinaryResponse) throws IOException {
        CompatibilityFactory compatibilityFactory = coreConfig.getCompatibilityFactory();
        switch (this.responseClassType) {
            case API_RESPONSE: {
                return (ResponseType)compatibilityFactory.createApiResponse(httpResponse.getStatusCode(), httpResponse.getHeaders(), (Object)(hasBinaryResponse ? httpResponse.getRawBody() : this.applyDeserializer(this.intermediateDeserializer, httpResponse)));
            }
            case DYNAMIC_RESPONSE: {
                return this.createDynamicResponse(httpResponse, compatibilityFactory);
            }
            case DYNAMIC_API_RESPONSE: {
                return (ResponseType)compatibilityFactory.createApiResponse(httpResponse.getStatusCode(), httpResponse.getHeaders(), this.createDynamicResponse(httpResponse, compatibilityFactory));
            }
        }
        return null;
    }

    private ResponseType createDynamicResponse(Response httpResponse, CompatibilityFactory compatibilityFactory) {
        return (ResponseType)compatibilityFactory.createDynamicResponse(httpResponse);
    }

    private void validateResponse(Context httpContext) throws ExceptionType {
        Response response = httpContext.getResponse();
        int statusCode = response.getStatusCode();
        String errorCode = String.valueOf(statusCode);
        this.throwConfiguredException(this.localErrorCases, errorCode, httpContext);
        this.throwConfiguredException(this.globalErrorCases, errorCode, httpContext);
        if (statusCode < 200 || statusCode > 208) {
            this.globalErrorCases.get("DEFAULT").throwException(httpContext);
        }
    }

    private void throwConfiguredException(Map<String, ErrorCase<ExceptionType>> errorCases, String errorCode, Context httpContext) throws ExceptionType {
        String defaultErrorCode = "";
        Matcher match = Pattern.compile("^[(4|5)[0-9]]{3}").matcher(errorCode);
        if (match.find()) {
            defaultErrorCode = errorCode.charAt(0) + "XX";
        }
        if (errorCases != null) {
            if (errorCases.containsKey(errorCode)) {
                errorCases.get(errorCode).throwException(httpContext);
            }
            if (errorCases.containsKey(defaultErrorCode)) {
                errorCases.get(defaultErrorCode).throwException(httpContext);
            }
        }
    }

    public static class Builder<ResponseType, ExceptionType extends CoreApiException> {
        private Map<String, ErrorCase<ExceptionType>> localErrorCases = null;
        private Map<String, ErrorCase<ExceptionType>> globalErrorCases = null;
        private Deserializer<ResponseType> deserializer;
        private Deserializer<?> intermediateDeserializer;
        private ResponseClassType responseClassType;
        private ContextInitializer<ResponseType> contextInitializer;
        private boolean isNullify404Enabled = true;
        private boolean isNullableResponseType = false;

        public Builder<ResponseType, ExceptionType> localErrorCase(String statusCode, ErrorCase<ExceptionType> errorCase) {
            if (this.localErrorCases == null) {
                this.localErrorCases = new HashMap<String, ErrorCase<ExceptionType>>();
            }
            this.localErrorCases.put(statusCode, errorCase);
            return this;
        }

        public Builder<ResponseType, ExceptionType> globalErrorCase(Map<String, ErrorCase<ExceptionType>> globalErrorCases) {
            this.globalErrorCases = globalErrorCases;
            return this;
        }

        public Builder<ResponseType, ExceptionType> deserializer(Deserializer<ResponseType> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public <IntermediateResponseType> Builder<ResponseType, ExceptionType> apiResponseDeserializer(Deserializer<IntermediateResponseType> intermediateDeserializer) {
            this.intermediateDeserializer = intermediateDeserializer;
            return this;
        }

        public Builder<ResponseType, ExceptionType> responseClassType(ResponseClassType responseClassType) {
            this.responseClassType = responseClassType;
            return this;
        }

        public Builder<ResponseType, ExceptionType> contextInitializer(ContextInitializer<ResponseType> contextInitializer) {
            this.contextInitializer = contextInitializer;
            return this;
        }

        public Builder<ResponseType, ExceptionType> nullify404(boolean isNullify404Enabled) {
            this.isNullify404Enabled = isNullify404Enabled;
            return this;
        }

        public Builder<ResponseType, ExceptionType> nullableResponseType(boolean isNullableResponseType) {
            this.isNullableResponseType = isNullableResponseType;
            return this;
        }

        public ResponseHandler<ResponseType, ExceptionType> build() {
            return new ResponseHandler(this.localErrorCases, this.globalErrorCases, this.deserializer, this.intermediateDeserializer, this.responseClassType, this.contextInitializer, this.isNullify404Enabled, this.isNullableResponseType);
        }
    }
}

