/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types;

import com.fasterxml.jackson.annotation.JsonGetter;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AdditionalProperties<T> {
    private final Map<String, T> properties = new LinkedHashMap<String, T>();
    private final Set<String> modelProperties = new HashSet<String>();

    public AdditionalProperties() {
    }

    public AdditionalProperties(Class<?> classInstance) {
        Method[] methods;
        for (Method method : methods = classInstance.getMethods()) {
            JsonGetter jsonGetter = method.getAnnotation(JsonGetter.class);
            if (jsonGetter == null) continue;
            this.modelProperties.add(jsonGetter.value());
        }
    }

    public Map<String, T> getAdditionalProperties() {
        return this.properties;
    }

    public void setAdditionalProperty(String key, T value) {
        if (key == null || key.trim().isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty.");
        }
        if (this.modelProperties.contains(key)) {
            throw new IllegalArgumentException("Key '" + key + "' conflicts with a model property.");
        }
        this.properties.put(key, value);
    }

    public void setAdditionalProperty(String key, T value, boolean skipNullValue) {
        if (skipNullValue && value == null) {
            return;
        }
        this.setAdditionalProperty(key, value);
    }

    public String toString() {
        if (this.properties.isEmpty()) {
            return "";
        }
        return this.properties.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(", ", ", ", ""));
    }

    public T getAdditionalProperty(String key) {
        return this.properties.get(key);
    }
}

