/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.dart.adapter.javapoet;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import io.apisense.generation.dart.adapter.javapoet.JavaGenerator;
import io.apisense.interpretor.main.StringUtils;

public abstract class JavaPoetGenerator
implements JavaGenerator {
    private static final String OUT_PACKAGE = "io.apisense.dart";
    private static final String DART_PACKAGE = "io.apisense.dart";
    protected static final String DART_LIB_PACKAGE = "io.apisense.dart.lib";
    protected static final String DART_API_PACKAGE = "io.apisense.dart.api";
    protected static final ClassName TOKEN_CLASS = ClassName.get((String)"io.apisense.dart.api", (String)"Token", (String[])new String[0]);
    protected TypeSpec.Builder contentBuilder;
    private String dartName;
    private final String classSuffix;

    public JavaPoetGenerator(String classSuffix) {
        this.classSuffix = classSuffix;
    }

    @Override
    public String fileContent() {
        if (this.contentBuilder == null || this.dartName == null) {
            return null;
        }
        JavaFile.Builder javaFile = JavaFile.builder((String)this.generationPackage(), (TypeSpec)this.contentBuilder.build()).skipJavaLangImports(true);
        return javaFile.build().toString();
    }

    @Override
    public String className() {
        if (this.dartName == null) {
            throw new IllegalStateException("Cannot use className() until dart set");
        }
        return StringUtils.capitalize(this.dartName) + this.classSuffix;
    }

    protected String generationPackage() {
        if (this.dartName == null) {
            throw new IllegalStateException("Cannot use generationPackage() until dart set");
        }
        return "io.apisense.dart." + this.dartName.toLowerCase();
    }

    protected ClassName currentClass() {
        return ClassName.get((String)this.generationPackage(), (String)this.className(), (String[])new String[0]);
    }

    protected String dartName() {
        if (this.dartName == null) {
            throw new IllegalStateException("Cannot use dartName() until dart set");
        }
        return this.dartName;
    }

    protected void setDartName(String dartName) {
        this.dartName = dartName;
    }
}

