/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.interpretor.structure;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.apisense.interpretor.structure.DartVisitor;
import io.apisense.interpretor.structure.Describable;
import io.apisense.interpretor.structure.Seed;
import io.apisense.interpretor.structure.Sprout;
import io.apisense.interpretor.structure.Treatment;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Dart
extends Describable {
    private String name;
    private List<Seed> seeds;
    private List<Sprout> sprouts;
    private List<Treatment> methods;

    public Dart() {
    }

    public Dart(String name, List<Seed> seeds, List<Sprout> sprouts, String description, Map<String, String> properties) {
        super(description, properties);
        this.name = name;
        this.seeds = seeds;
        this.sprouts = sprouts;
    }

    public String getName() {
        return this.name;
    }

    public List<Seed> getSeeds() {
        return this.seeds != null ? this.seeds : Collections.emptyList();
    }

    public List<Sprout> getSprouts() {
        return this.sprouts != null ? this.sprouts : Collections.emptyList();
    }

    public List<Treatment> getMethods() {
        return this.methods != null ? this.methods : Collections.emptyList();
    }

    public boolean hasFilters() {
        for (Sprout s : this.sprouts) {
            if (s.getFilters().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public Map<File, String> accept(DartVisitor visitor, File output) throws IOException {
        visitor.visitDart(this, output);
        for (Seed seed : this.getSeeds()) {
            seed.accept(visitor);
        }
        for (Sprout sprout : this.getSprouts()) {
            sprout.accept(visitor);
        }
        for (Treatment method : this.getMethods()) {
            method.accept(visitor);
        }
        return visitor.results(output);
    }
}

