/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.dart.html;

import io.apisense.generation.dart.adapter.velocity.VelocityGenerator;
import io.apisense.generation.dart.html.ForbiddenVariables;
import io.apisense.interpretor.main.StringUtils;
import io.apisense.interpretor.structure.Dart;
import io.apisense.interpretor.structure.Seed;
import io.apisense.interpretor.structure.Sprout;
import java.io.File;
import java.io.IOException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;

final class GenerateHTML
extends VelocityGenerator {
    private static final String INDEX_TEMPLATE = "Index";
    private static final String DATA_TEMPLATE = "Data";
    private static final String SEED_TEMPLATE = "Seed";
    private static final String FILTER_TEMPLATE = "Filter";

    GenerateHTML(String dartName) {
        super(dartName);
    }

    @Override
    protected String getTemplatePath(String name) {
        return "/template/HTML/" + name + ".vm";
    }

    void generateIndex(Dart dart) throws IOException {
        Template t = this.loadTemplate(INDEX_TEMPLATE);
        VelocityContext context = this.minimalContext();
        context.put("dart", (Object)dart);
        context.put("ForbiddenVariables", ForbiddenVariables.class);
        String fileName = INDEX_TEMPLATE.toLowerCase();
        this.generated.put(fileName, this.fillTemplate(t, context));
    }

    void generateData(Dart dart) throws IOException {
        Template t = this.loadTemplate(DATA_TEMPLATE);
        VelocityContext context = this.minimalContext();
        context.put("dart", (Object)dart);
        context.put("sortedSeeds", dart.allSeeds());
        String fileName = this.dartName + DATA_TEMPLATE;
        this.generated.put(fileName, this.fillTemplate(t, context));
    }

    void generateSeedEnum(String dartName, Seed seed) throws IOException {
        Template t = this.loadTemplate(SEED_TEMPLATE);
        VelocityContext context = this.minimalContext();
        context.put("dartName", (Object)dartName);
        context.put("seed", (Object)seed);
        String fileName = dartName + StringUtils.capitalize(seed.getName());
        this.generated.put(fileName, this.fillTemplate(t, context));
    }

    void generateFilter(Dart dart, Sprout sprout) throws IOException {
        if (!sprout.getFilters().isEmpty()) {
            Template t = this.loadTemplate(FILTER_TEMPLATE);
            VelocityContext context = this.minimalContext();
            context.put("dart", (Object)dart);
            context.put("sprout", (Object)sprout);
            String fileName = sprout.eventName() + FILTER_TEMPLATE;
            this.generated.put(fileName, this.fillTemplate(t, context));
        }
    }

    @Override
    protected File getOutputFile(File parentDir, String suffix) {
        return new File(parentDir, suffix + ".md");
    }
}

