/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.interpretor.structure;

import io.apisense.generation.dart.GeneratedType;
import io.apisense.interpretor.structure.DartVisitor;
import io.apisense.interpretor.structure.Describable;
import io.apisense.interpretor.structure.Parameter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Seed
extends Describable
implements Comparable<Seed> {
    private String name;
    private GeneratedType type;
    private List<Parameter> parameters;

    public Seed() {
    }

    public Seed(String name, GeneratedType type, List<Parameter> parameters, String description, Map<String, String> properties) {
        super(description, properties);
        this.name = name;
        this.type = type;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public GeneratedType getType() {
        return this.type;
    }

    public List<Parameter> getParameters() {
        return this.parameters != null ? this.parameters : Collections.emptyList();
    }

    public void accept(DartVisitor visitor) throws IOException {
        visitor.visitSeed(this);
    }

    @Override
    public int compareTo(Seed s) {
        return this.name.compareToIgnoreCase(s.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Seed seed = (Seed)o;
        return this.name.equals(seed.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

