/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.dart.html;

import io.apisense.generation.dart.GenericVisitor;
import io.apisense.generation.dart.html.GenerateHTML;
import io.apisense.interpretor.structure.Dart;
import io.apisense.interpretor.structure.Enumeration;
import io.apisense.interpretor.structure.Seed;
import io.apisense.interpretor.structure.Sprout;
import io.apisense.interpretor.structure.Treatment;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class HTMLVisitor
extends GenericVisitor {
    private Dart dart;
    private final GenerateHTML genHTML;

    public HTMLVisitor(String dartName) {
        super(dartName);
        this.genHTML = new GenerateHTML(dartName);
    }

    @Override
    public void visitDart(Dart dart, File output) throws IOException {
        this.dart = dart;
        this.genHTML.generateData(dart);
        this.genHTML.generateIndex(dart);
    }

    @Override
    public void visitSeed(Seed seed) throws IOException {
        if (seed.getType() instanceof Enumeration) {
            this.genHTML.generateSeedEnum(this.dartName, seed);
        }
    }

    @Override
    public void visitSprout(Sprout sprout) throws IOException {
        if (!sprout.areFiltersPrivate()) {
            this.genHTML.generateFilter(this.dart, sprout);
        }
    }

    @Override
    public void visitTreatment(Treatment treatment) {
    }

    @Override
    public Map<File, String> results(File parent) {
        return this.genHTML.filesContent(this.outputDir(parent));
    }
}

