/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.netsense;

import io.apisense.dart.lib.BitMask;
import java.util.EnumSet;

public enum NetsenseEvent {
    PACKET("netsense:packet:"),
    IN_PACKET("netsense:in:packet"),
    OUT_PACKET("netsense:out:packet"),
    DNS_PACKET("netsense:dns:packet");

    private final int value = 1 << this.ordinal();
    private final String label;

    private NetsenseEvent(String label) {
        this.label = label;
    }

    public int value() {
        return this.value;
    }

    public final boolean matches(int value) {
        return BitMask.matches((int)this.value, (int)value);
    }

    public final boolean equals(String label) {
        return this.label.equalsIgnoreCase(label);
    }

    public final String toString() {
        return this.label;
    }

    public static final EnumSet<NetsenseEvent> parse(String ... labels) {
        EnumSet<NetsenseEvent> res = EnumSet.noneOf(NetsenseEvent.class);
        for (String label : labels) {
            for (NetsenseEvent val : NetsenseEvent.values()) {
                if (!val.equals(label)) continue;
                res.add(val);
            }
        }
        return res;
    }

    public static final EnumSet<NetsenseEvent> parse(int ... codes) {
        EnumSet<NetsenseEvent> res = EnumSet.noneOf(NetsenseEvent.class);
        for (int code : codes) {
            for (NetsenseEvent val : NetsenseEvent.values()) {
                if (!val.matches(code)) continue;
                res.add(val);
            }
        }
        return res;
    }
}

