/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.netsense;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;
import io.apisense.dart.lib.EventBus;
import io.apisense.dart.lib.EventFilter;
import io.apisense.dart.lib.Tokens;
import io.apisense.dart.netsense.NetsenseDartSkel;
import io.apisense.dart.netsense.NetsenseEvent;
import io.apisense.dart.netsense.NetsenseSeed;
import io.apisense.sting.lib.Sensor;
import io.apisense.sting.netsense.NetsenseActivity;
import io.apisense.sting.netsense.NetsenseService;
import io.apisense.sting.netsense.R;
import io.apisense.sting.netsense.data.dns.DnsAnswerData;
import io.apisense.sting.netsense.data.http.HttpData;
import io.apisense.sting.netsense.data.https.HttpsData;
import io.apisense.sting.netsense.data.other.tcp.OtherTcpData;
import io.apisense.sting.netsense.data.other.udp.OtherUdpData;
import io.apisense.sting.netsense.data.quic.QuicData;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;

public class NetsenseSting
extends NetsenseDartSkel {
    private static final String TAG = NetsenseSting.class.getSimpleName();
    public static final String STOP = "io.apisense.sting.network.netsense.STOP";
    public static final String STARTED = "io.apisense.sting.network.netsense.STARTED";
    public static final String STATS_MONITOR_ACTION = "io.apisense.sting.network.netsense.STATS_MONITOR";
    public static final String MONITORS_EXTRA = "monitors";
    public static final Sensor SENSOR_DESCRIPTION = new Sensor("Network traffic", "netsense", "Measure the network traffic", R.drawable.aps_netsense, new String[0]);
    private final Context context;
    private final EventBus bus;
    private final Handler handler;
    private ServiceConnection connection;
    private NetsenseService service;
    private StartedReceiver startedReceiver;

    @Inject
    protected NetsenseSting(EventBus bus, Context context) {
        super(bus, EnumSet.allOf(NetsenseSeed.class));
        this.context = context;
        this.bus = bus;
        this.handler = new Handler();
    }

    @Override
    public void statsMonitor(final List<String> protocols) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (NetsenseSting.this.service != null) {
                    NetsenseSting.this.sendStatsMonitorIntent(protocols);
                } else {
                    NetsenseSting.this.statsMonitor(protocols);
                }
            }
        }, 1000L);
    }

    @Override
    public void statsMonitor() {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("ALL");
        this.statsMonitor(protocols);
    }

    private void sendStatsMonitorIntent(List<String> protocols) {
        Intent intent = new Intent(STATS_MONITOR_ACTION);
        intent.putStringArrayListExtra(MONITORS_EXTRA, new ArrayList<String>(protocols));
        this.context.sendBroadcast(intent);
    }

    @Override
    public HttpData getHttpData() {
        return this.service.getHttpData();
    }

    @Override
    public HttpsData getHttpsData() {
        return this.service.getHttpsData();
    }

    @Override
    public QuicData getQuicData() {
        return this.service.getQuicData();
    }

    @Override
    public OtherTcpData getOtherTcpData() {
        return this.service.getOtherTcpData();
    }

    @Override
    public OtherUdpData getOtherUdpData() {
        return this.service.getOtherUdpData();
    }

    @Override
    public DnsAnswerData getDnsAnswerData() {
        return this.service.getDnsAnswerData();
    }

    @Override
    public void exportPcap() {
        this.service.exportPcap(this.getId());
    }

    @Override
    public void resetPcap() {
        this.service.resetPcap();
    }

    private void connectToService() {
        this.connection = new ServiceConnection(){

            public void onServiceConnected(ComponentName className, IBinder binder) {
                Log.d((String)TAG, (String)"Connected to the NetsenseService");
                NetsenseSting.this.service = ((NetsenseService.NetsenseBinder)binder).getService();
                NetsenseSting.this.service.setBus(NetsenseSting.this.bus);
            }

            public void onServiceDisconnected(ComponentName className) {
                Log.d((String)TAG, (String)"Disconnected from the NetsenseService");
            }
        };
        Intent ntnt = new Intent(this.context, NetsenseService.class);
        this.context.bindService(ntnt, this.connection, 4);
    }

    private void disconnectFromService() {
        if (this.connection != null) {
            this.context.unbindService(this.connection);
            this.connection = null;
        }
    }

    @Override
    protected Tokens.TokensListener<Void> initPacketListener() {
        return new PacketHandledListener(NetsenseEvent.PACKET);
    }

    @Override
    protected Tokens.TokensListener<Void> initInPacketListener() {
        return new PacketHandledListener(NetsenseEvent.IN_PACKET);
    }

    @Override
    protected Tokens.TokensListener<Void> initOutPacketListener() {
        return new PacketHandledListener(NetsenseEvent.OUT_PACKET);
    }

    @Override
    protected Tokens.TokensListener<Void> initDnsPacketListener() {
        return new PacketHandledListener(NetsenseEvent.DNS_PACKET);
    }

    public void start() {
        super.start();
        this.startedReceiver = new StartedReceiver();
        this.context.registerReceiver((BroadcastReceiver)this.startedReceiver, new IntentFilter(STARTED));
        Intent intent = new Intent(this.context, NetsenseActivity.class);
        intent.setFlags(0x10000000);
        this.context.startActivity(intent);
    }

    @Override
    public void stop() {
        Log.d((String)TAG, (String)"[stop]");
        Intent intent = new Intent();
        intent.setAction(STOP);
        this.context.sendBroadcast(intent);
        this.disconnectFromService();
        super.stop();
    }

    private void unregisterStartedReceiver() {
        if (this.startedReceiver == null) {
            return;
        }
        this.context.unregisterReceiver((BroadcastReceiver)this.startedReceiver);
        this.startedReceiver = null;
    }

    private final class PacketHandledListener
    implements Tokens.TokensListener<Void> {
        private final NetsenseEvent event;

        public PacketHandledListener(NetsenseEvent event) {
            this.event = event;
        }

        public void init() {
        }

        public String computeTopic(EventFilter<Void> eventFilter) {
            return this.event.toString();
        }

        public void discardFilter(EventFilter<Void> eventFilter) {
        }

        public void release() {
        }
    }

    private final class StartedReceiver
    extends BroadcastReceiver {
        private StartedReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            NetsenseSting.this.connectToService();
            NetsenseSting.this.unregisterStartedReceiver();
        }
    }
}

