/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.netsense.monitor;

import android.util.Log;
import io.apisense.sting.netsense.HttpPacket;
import io.apisense.sting.netsense.Packet;
import io.apisense.sting.netsense.data.Application;
import io.apisense.sting.netsense.data.http.AllHttp1Application;
import io.apisense.sting.netsense.data.http.AllHttp2Application;
import io.apisense.sting.netsense.data.http.FirstHttpApplication;
import io.apisense.sting.netsense.data.http.HttpData;
import io.apisense.sting.netsense.monitor.Monitor;
import java.util.ArrayList;
import java.util.HashMap;

public class HttpMonitor
implements Monitor {
    private static final String TAG = HttpMonitor.class.getSimpleName();
    private int nbFirstHttpPackets;
    private int nbAllHttp1Packets;
    private int nbAllHttp2Packets;
    private HashMap<String, Integer> nbFirstHttpPacketsForIps;
    private HashMap<Application, Integer> nbFirstHttpPacketsForApplications;
    private HashMap<Application, Integer> nbAllHttp1PacketsForApplications;
    private HashMap<Application, Integer> nbAllHttp2PacketsForApplications;

    public HttpMonitor() {
        Log.d((String)TAG, (String)(TAG + " started."));
        this.nbFirstHttpPacketsForIps = new HashMap();
        this.nbFirstHttpPacketsForApplications = new HashMap();
        this.nbAllHttp1PacketsForApplications = new HashMap();
        this.nbAllHttp2PacketsForApplications = new HashMap();
    }

    @Override
    public void processPacket(Packet packet, Application application) {
        if (!HttpMonitor.isHttp(packet)) {
            return;
        }
        Log.d((String)TAG, (String)packet.toString());
        if (packet.first) {
            this.incNbFirstHttpPackets();
            this.incNbFirstHttpPacketsForApplication(application);
            this.incNbFirstHttpPacketsForIp(packet.daddr);
        }
        if (((HttpPacket)packet).httpVersion == 1) {
            this.incNbAllHttp1Packets();
            this.incNbAllHttp1PacketsForApplication(application);
        } else if (((HttpPacket)packet).httpVersion == 2) {
            this.incNbAllHttp2Packets();
            this.incNbAllHttp2PacketsForApplication(application);
        }
    }

    private void incNbFirstHttpPackets() {
        ++this.nbFirstHttpPackets;
    }

    private void incNbAllHttp1Packets() {
        ++this.nbAllHttp1Packets;
    }

    private void incNbAllHttp2Packets() {
        ++this.nbAllHttp2Packets;
    }

    private void incNbFirstHttpPacketsForIp(String ip) {
        Integer nbFirstHttpPacketsForIp = this.nbFirstHttpPacketsForIps.get(ip);
        if (nbFirstHttpPacketsForIp != null) {
            this.nbFirstHttpPacketsForIps.put(ip, nbFirstHttpPacketsForIp + 1);
            return;
        }
        this.nbFirstHttpPacketsForIps.put(ip, 1);
    }

    private void incNbFirstHttpPacketsForApplication(Application application) {
        Integer nbFirstHttpPacketsForApplication = this.nbFirstHttpPacketsForApplications.get(application);
        if (nbFirstHttpPacketsForApplication != null) {
            this.nbFirstHttpPacketsForApplications.put(application, nbFirstHttpPacketsForApplication + 1);
            return;
        }
        this.nbFirstHttpPacketsForApplications.put(application, 1);
    }

    private void incNbAllHttp1PacketsForApplication(Application application) {
        Integer nbAllHttp1PacketsForApplication = this.nbAllHttp1PacketsForApplications.get(application);
        if (nbAllHttp1PacketsForApplication != null) {
            this.nbAllHttp1PacketsForApplications.put(application, nbAllHttp1PacketsForApplication + 1);
            return;
        }
        this.nbAllHttp1PacketsForApplications.put(application, 1);
    }

    private void incNbAllHttp2PacketsForApplication(Application application) {
        Integer nbAllHttp2PacketsForApplication = this.nbAllHttp2PacketsForApplications.get(application);
        if (nbAllHttp2PacketsForApplication != null) {
            this.nbAllHttp2PacketsForApplications.put(application, nbAllHttp2PacketsForApplication + 1);
            return;
        }
        this.nbAllHttp2PacketsForApplications.put(application, 1);
    }

    public HttpData getHttpData() {
        ArrayList<FirstHttpApplication> nbFrstHttpPcktsFrpplctns = new ArrayList<FirstHttpApplication>();
        for (Application application : this.nbFirstHttpPacketsForApplications.keySet()) {
            nbFrstHttpPcktsFrpplctns.add(new FirstHttpApplication(application, this.nbFirstHttpPacketsForApplications.get(application)));
        }
        ArrayList<AllHttp1Application> nbllHttp1PcktsFrpplctns = new ArrayList<AllHttp1Application>();
        for (Application application : this.nbAllHttp1PacketsForApplications.keySet()) {
            nbllHttp1PcktsFrpplctns.add(new AllHttp1Application(application, this.nbAllHttp1PacketsForApplications.get(application)));
        }
        ArrayList<AllHttp2Application> arrayList = new ArrayList<AllHttp2Application>();
        for (Application application : this.nbAllHttp2PacketsForApplications.keySet()) {
            arrayList.add(new AllHttp2Application(application, this.nbAllHttp2PacketsForApplications.get(application)));
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(this.nbFirstHttpPacketsForIps);
        return new HttpData(this.nbFirstHttpPackets, this.nbAllHttp1Packets, this.nbAllHttp2Packets, nbFrstHttpPcktsFrpplctns, nbllHttp1PcktsFrpplctns, arrayList, hashMap);
    }

    @Override
    public void reset() {
        this.nbFirstHttpPackets = 0;
        this.nbAllHttp1Packets = 0;
        this.nbAllHttp2Packets = 0;
        this.nbFirstHttpPacketsForApplications.clear();
        this.nbAllHttp1PacketsForApplications.clear();
        this.nbAllHttp2PacketsForApplications.clear();
        this.nbFirstHttpPacketsForIps.clear();
    }

    public static boolean isHttp(Packet packet) {
        return packet instanceof HttpPacket && packet.protocol == 6 && (packet.dport == 80 || packet.sport == 80);
    }
}

