/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.netsense.monitor;

import android.util.Log;
import io.apisense.sting.netsense.Packet;
import io.apisense.sting.netsense.data.Application;
import io.apisense.sting.netsense.data.https.FirstHttpsApplication;
import io.apisense.sting.netsense.data.https.HttpsData;
import io.apisense.sting.netsense.monitor.Monitor;
import java.util.ArrayList;
import java.util.HashMap;

public class HttpsMonitor
implements Monitor {
    private static final String TAG = HttpsMonitor.class.getSimpleName();
    private int nbFirstHttpsPackets;
    private HashMap<String, Integer> nbFirstHttpsPacketsForIps;
    private HashMap<Application, Integer> nbFirstHttpsPacketsForApplications;

    public HttpsMonitor() {
        Log.d((String)TAG, (String)(TAG + " started."));
        this.nbFirstHttpsPacketsForIps = new HashMap();
        this.nbFirstHttpsPacketsForApplications = new HashMap();
    }

    @Override
    public void processPacket(Packet packet, Application application) {
        if (!HttpsMonitor.isHttps(packet)) {
            return;
        }
        if (packet.first) {
            this.incNbFirstHttpsPackets();
            this.incNbFirstHttpsPacketsForApplication(application);
            this.incNbFirstHttpsPacketsForIp(packet.daddr);
        }
    }

    private void incNbFirstHttpsPackets() {
        ++this.nbFirstHttpsPackets;
    }

    private void incNbFirstHttpsPacketsForApplication(Application application) {
        Integer nbFirstHttpsPacketsForApplication = this.nbFirstHttpsPacketsForApplications.get(application);
        if (nbFirstHttpsPacketsForApplication != null) {
            this.nbFirstHttpsPacketsForApplications.put(application, nbFirstHttpsPacketsForApplication + 1);
            return;
        }
        this.nbFirstHttpsPacketsForApplications.put(application, 1);
    }

    private void incNbFirstHttpsPacketsForIp(String ip) {
        Integer nbFirstHttpsPacketsForIp = this.nbFirstHttpsPacketsForIps.get(ip);
        if (nbFirstHttpsPacketsForIp != null) {
            this.nbFirstHttpsPacketsForIps.put(ip, nbFirstHttpsPacketsForIp + 1);
            return;
        }
        this.nbFirstHttpsPacketsForIps.put(ip, 1);
    }

    public HttpsData getHttpsData() {
        ArrayList<FirstHttpsApplication> nbFrstHttpsPcktsFrpplctns = new ArrayList<FirstHttpsApplication>();
        for (Application application : this.nbFirstHttpsPacketsForApplications.keySet()) {
            nbFrstHttpsPcktsFrpplctns.add(new FirstHttpsApplication(application, this.nbFirstHttpsPacketsForApplications.get(application)));
        }
        HashMap<String, Integer> nbFrstHttpsPcktsFrps = new HashMap<String, Integer>(this.nbFirstHttpsPacketsForIps);
        return new HttpsData(this.nbFirstHttpsPackets, nbFrstHttpsPcktsFrpplctns, nbFrstHttpsPcktsFrps);
    }

    @Override
    public void reset() {
        this.nbFirstHttpsPackets = 0;
        this.nbFirstHttpsPacketsForApplications.clear();
        this.nbFirstHttpsPacketsForIps.clear();
    }

    public static boolean isHttps(Packet packet) {
        return packet.protocol == 6 && (packet.dport == 443 || packet.sport == 443);
    }
}

