{
    "name": "netsense",
    "type": "dart",
    "description": "Collect network traffic measurements.",
    "methods": [
        {
            "name": "statsMonitor",
            "description": "Start the internal protocol stats monitoring with protocols.",
            "parameters": [
                {
                    "name": "protocols",
                    "type": "List<String>",
                    "description": "Array containing the list of protocols to monitor"
                }
            ],
            "type": "void"
        },
        {
            "name": "statsMonitor",
            "description": "Start the internal protocol stats monitoring.",
            "type": "void"
        },
        {
            "name": "getHttpData",
            "description": "Return information about the HTTP monitored traffic",
            "type": "io.apisense.sting.netsense.data.http.HttpData"
        },
        {
            "name": "getHttpsData",
            "description": "Return information about the HTTPS monitored traffic",
            "type": "io.apisense.sting.netsense.data.https.HttpsData"
        },
        {
            "name": "getQuicData",
            "description": "Return information about the QUIC monitored traffic",
            "type": "io.apisense.sting.netsense.data.quic.QuicData"
        },
        {
            "name": "getOtherTcpData",
            "description": "Return information about the Other TCP monitored traffic",
            "type": "io.apisense.sting.netsense.data.other.tcp.OtherTcpData"
        },
        {
            "name": "getOtherUdpData",
            "description": "Return information about the Other UDP monitored traffic",
            "type": "io.apisense.sting.netsense.data.other.udp.OtherUdpData"
        },
        {
            "name": "getDnsAnswerData",
            "description": "Return information about the DNS monitored Answers",
            "type": "io.apisense.sting.netsense.data.dns.DnsAnswerData"
        },
        {
            "name": "exportPcap",
            "description": "Export the traffic in a pcap file ready to be uploaded",
            "type": "void"
        },
        {
            "name": "resetPcap",
            "description": "Reset the traffic in a pcap file",
            "type": "void"
        }
    ],
    "sprouts": [
        {
            "event": "packet",
            "description": "Send an event when an in/out packet is handled."
        },
        {
            "event": "in:packet",
            "description": "Send an event when an incoming packet is handled."
        },
        {
            "event": "out:packet",
            "description": "Send an event when an outgoing packet is handled."
        },
        {
            "event": "dns:packet",
            "description": "Send an event when a DNS answer packet is handled."
        }
    ]
}