/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.netsense;

import io.apisense.dart.api.Data;
import io.apisense.dart.api.Seed;
import io.apisense.dart.api.Token;
import io.apisense.dart.lib.DartImpl;
import io.apisense.dart.lib.Event;
import io.apisense.dart.lib.EventBus;
import io.apisense.dart.lib.Tokens;
import io.apisense.dart.lib.events.EventListenerTriggered;
import io.apisense.dart.netsense.NetsenseDart;
import io.apisense.dart.netsense.NetsenseData;
import io.apisense.dart.netsense.NetsenseEvent;
import io.apisense.dart.netsense.NetsenseSeed;
import java.util.EnumSet;
import java.util.Set;

public abstract class NetsenseDartSkel
extends DartImpl<NetsenseData>
implements NetsenseDart {
    private final EventBus bus;
    private Tokens<Void> packet;
    private Tokens<Void> inPacket;
    private Tokens<Void> outPacket;
    private Tokens<Void> dnsPacket;
    private Tokens<Void> init;

    protected NetsenseDartSkel(EventBus bus, Set<? extends Seed> fields) {
        super(NetsenseDart.class, fields);
        this.bus = bus;
    }

    protected NetsenseDartSkel(EventBus bus) {
        super(NetsenseDart.class, EnumSet.allOf(NetsenseSeed.class));
        this.bus = bus;
    }

    protected abstract Tokens.TokensListener<Void> initPacketListener();

    @Override
    public Token onPacket(Object callback) {
        return this.getPacket().register(callback, null);
    }

    private Tokens<Void> getPacket() {
        if (this.packet == null) {
            this.packet = new Tokens(this.bus, this.initPacketListener());
        }
        return this.packet;
    }

    protected abstract Tokens.TokensListener<Void> initInPacketListener();

    @Override
    public Token onInPacket(Object callback) {
        return this.getInPacket().register(callback, null);
    }

    private Tokens<Void> getInPacket() {
        if (this.inPacket == null) {
            this.inPacket = new Tokens(this.bus, this.initInPacketListener());
        }
        return this.inPacket;
    }

    protected abstract Tokens.TokensListener<Void> initOutPacketListener();

    @Override
    public Token onOutPacket(Object callback) {
        return this.getOutPacket().register(callback, null);
    }

    private Tokens<Void> getOutPacket() {
        if (this.outPacket == null) {
            this.outPacket = new Tokens(this.bus, this.initOutPacketListener());
        }
        return this.outPacket;
    }

    protected abstract Tokens.TokensListener<Void> initDnsPacketListener();

    @Override
    public Token onDnsPacket(Object callback) {
        return this.getDnsPacket().register(callback, null);
    }

    private Tokens<Void> getDnsPacket() {
        if (this.dnsPacket == null) {
            this.dnsPacket = new Tokens(this.bus, this.initDnsPacketListener());
        }
        return this.dnsPacket;
    }

    protected abstract Tokens.TokensListener<Void> initInitListener();

    @Override
    public Token onInit(Object callback) {
        return this.getInit().register(callback, null);
    }

    private Tokens<Void> getInit() {
        if (this.init == null) {
            this.init = new Tokens(this.bus, this.initInitListener());
        }
        return this.init;
    }

    public NetsenseData map(int mask) {
        return new NetsenseData();
    }

    protected final void publish(NetsenseEvent event, NetsenseData dataClass) {
        this.bus.publish((Event)EventListenerTriggered.build((String)event.toString(), (Data)dataClass, null));
    }

    public void stop() {
        this.getPacket().stop();
        this.getInPacket().stop();
        this.getOutPacket().stop();
        this.getDnsPacket().stop();
        this.getInit().stop();
    }
}

