/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.netsense;

import io.apisense.dart.api.Seed;
import io.apisense.dart.lib.BitMask;
import java.util.EnumSet;

public enum NetsenseSeed implements Seed
{
    TIMESTAMP("timestamp", Long.class);

    private final int value = 1 << this.ordinal();
    private final String label;
    private final Class type;

    private NetsenseSeed(String label, Class type) {
        this.label = label;
        this.type = type;
    }

    public int value() {
        return this.value;
    }

    public Class type() {
        return this.type;
    }

    public final boolean matches(int value) {
        return BitMask.matches((int)this.value, (int)value);
    }

    public final boolean equals(String label) {
        return this.label.equalsIgnoreCase(label);
    }

    public final String toString() {
        return this.label;
    }

    public static final EnumSet<NetsenseSeed> parse(String ... labels) {
        EnumSet<NetsenseSeed> res = EnumSet.noneOf(NetsenseSeed.class);
        for (String label : labels) {
            for (NetsenseSeed val : NetsenseSeed.values()) {
                if (!val.equals(label)) continue;
                res.add(val);
            }
        }
        return res;
    }

    public static final EnumSet<NetsenseSeed> parse(int ... codes) {
        EnumSet<NetsenseSeed> res = EnumSet.noneOf(NetsenseSeed.class);
        for (int code : codes) {
            for (NetsenseSeed val : NetsenseSeed.values()) {
                if (!val.matches(code)) continue;
                res.add(val);
            }
        }
        return res;
    }
}

