/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.netsense;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.VpnService;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.util.Log;
import io.apisense.dart.api.Data;
import io.apisense.dart.lib.Event;
import io.apisense.dart.lib.EventBus;
import io.apisense.dart.lib.events.EventListenerTriggered;
import io.apisense.dart.netsense.NetsenseEvent;
import io.apisense.sdk.core.record.MediaRecord;
import io.apisense.sting.netsense.DnsAnswer;
import io.apisense.sting.netsense.NetsenseActivity;
import io.apisense.sting.netsense.Packet;
import io.apisense.sting.netsense.data.Application;
import io.apisense.sting.netsense.data.DnsPacketData;
import io.apisense.sting.netsense.data.PacketData;
import io.apisense.sting.netsense.data.dns.DnsAnswerData;
import io.apisense.sting.netsense.data.http.HttpData;
import io.apisense.sting.netsense.data.https.HttpsData;
import io.apisense.sting.netsense.data.other.tcp.OtherTcpData;
import io.apisense.sting.netsense.data.other.udp.OtherUdpData;
import io.apisense.sting.netsense.data.quic.QuicData;
import io.apisense.sting.netsense.monitor.DnsAnswerMonitor;
import io.apisense.sting.netsense.monitor.HttpMonitor;
import io.apisense.sting.netsense.monitor.HttpsMonitor;
import io.apisense.sting.netsense.monitor.Monitor;
import io.apisense.sting.netsense.monitor.OtherTcpMonitor;
import io.apisense.sting.netsense.monitor.OtherUdpMonitor;
import io.apisense.sting.netsense.monitor.QuicMonitor;
import io.apisense.sting.netsense.receiver.ConnectivityReceiver;
import io.apisense.sting.netsense.receiver.IdleReceiver;
import io.apisense.sting.netsense.receiver.InteractiveReceiver;
import io.apisense.sting.netsense.receiver.PackageReceiver;
import io.apisense.sting.netsense.receiver.StatsMonitorReceiver;
import io.apisense.sting.netsense.receiver.StopReceiver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class NetsenseService
extends VpnService {
    private static final String TAG = NetsenseService.class.getSimpleName();
    private static final int PCAP_MAX_RECORD_SIZE = 65535;
    private static final int PCAP_MAX_FILE_SIZE = 0x200000;
    private static final String PCAP_FILE_NAME = "netsense.pcap";
    private StopReceiver stopReceiver;
    private IdleReceiver idleReceiver;
    private PackageManager packageManager;
    private PowerManager powerManager;
    private ConnectivityReceiver connectivityReceiver;
    private InteractiveReceiver interactiveReceiver;
    private PackageReceiver packageReceiver;
    private Handler handler;
    private HashMap<String, Monitor> monitors;
    private ArrayList<String> monitorsToInstanciate;
    private EventBus bus;
    private StatsMonitorReceiver statsMonitorReceiver;
    private DnsAnswerMonitor dnsAnswerMonitor;
    private ParcelFileDescriptor parcelFileDescriptor;
    private final IBinder binder = new NetsenseBinder();

    private native void initNetGuard();

    private native void startNetGuard(int var1, boolean var2, int var3, int var4);

    private native void stopNetGuard(int var1, boolean var2);

    private native int getMtu();

    private static native void processPcap(String var0, int var1, int var2);

    private native String getProp(String var1);

    private native boolean isNumericAddress(String var1);

    public void onCreate() {
        super.onCreate();
        Log.d((String)TAG, (String)"\u2018 , . \u2018 \u02d1 , \u2018 .");
        this.packageManager = this.getPackageManager();
        this.powerManager = (PowerManager)this.getSystemService("power");
        IntentFilter stopIntentFilter = new IntentFilter("io.apisense.sting.network.netsense.STOP");
        this.stopReceiver = new StopReceiver(this);
        this.registerReceiver(this.stopReceiver, stopIntentFilter);
        if (Build.VERSION.SDK_INT >= 23) {
            IntentFilter idleIntentFilter = new IntentFilter("android.os.action.DEVICE_IDLE_MODE_CHANGED");
            this.idleReceiver = new IdleReceiver(this);
            this.registerReceiver(this.idleReceiver, idleIntentFilter);
        }
        IntentFilter connectivityIntentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.connectivityReceiver = new ConnectivityReceiver(this);
        this.registerReceiver(this.connectivityReceiver, connectivityIntentFilter);
        IntentFilter interactiveIntentFilter = new IntentFilter("android.intent.action.SCREEN_ON");
        interactiveIntentFilter.addAction("android.intent.action.SCREEN_OFF");
        this.interactiveReceiver = new InteractiveReceiver(this);
        this.registerReceiver(this.interactiveReceiver, interactiveIntentFilter);
        IntentFilter packageIntentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        packageIntentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        packageIntentFilter.addDataScheme("package");
        this.packageReceiver = new PackageReceiver(this);
        this.registerReceiver(this.packageReceiver, packageIntentFilter);
        IntentFilter statsMonitorIntentFilter = new IntentFilter("io.apisense.sting.network.netsense.STATS_MONITOR");
        this.statsMonitorReceiver = new StatsMonitorReceiver(this);
        this.registerReceiver(this.statsMonitorReceiver, statsMonitorIntentFilter);
        this.handler = new Handler();
        this.initNetGuard();
        this.startPcapRecording();
    }

    public PowerManager getPowerManager() {
        return this.powerManager;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.startVpn();
        this.sendBroadcast(new Intent("io.apisense.sting.network.netsense.STARTED"));
        return 1;
    }

    private void startPcapRecording() {
        File pcap = new File(this.getDir("data", 0), PCAP_FILE_NAME);
        NetsenseService.processPcap(pcap.getAbsolutePath(), 65535, 0x200000);
    }

    private void stopPcapRecording() {
        NetsenseService.processPcap(null, 65535, 0x200000);
    }

    public void resetPcap() {
        try {
            this.stopPcapRecording();
            File pcap = new File(this.getDir("data", 0), PCAP_FILE_NAME);
            if (pcap.delete()) {
                Log.i((String)TAG, (String)"Pcap file deleted");
            } else {
                Log.w((String)TAG, (String)"Pcap file cannot be deleted");
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        finally {
            this.startPcapRecording();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPcap(String cropId) {
        RandomAccessFile file = null;
        try {
            this.stopPcapRecording();
            File pcap = new File(this.getDir("data", 0), PCAP_FILE_NAME);
            file = new RandomAccessFile(pcap, "r");
            byte[] buffer = new byte[(int)file.length()];
            file.readFully(buffer);
            Log.i((String)TAG, (String)("Saving pcap for crop \"" + cropId + "\" (size=" + file.length() + ")"));
            String targetFileName = System.currentTimeMillis() + ".pcap";
            new MediaRecord(cropId, targetFileName).write(this.getApplicationContext(), buffer);
            if (pcap.delete()) {
                Log.i((String)TAG, (String)"Pcap file deleted");
            } else {
                Log.w((String)TAG, (String)"Pcap file cannot be deleted");
            }
            this.close(file);
            this.startPcapRecording();
        }
        catch (Throwable e) {
            try {
                Log.e((String)TAG, (String)e.getMessage());
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.close(file);
                this.startPcapRecording();
            }
        }
    }

    private void close(Closeable file) {
        if (file == null) {
            return;
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public HttpData getHttpData() {
        Monitor monitor = this.monitors.get("HTTP");
        if (monitor == null) {
            Log.w((String)TAG, (String)"The HTTP monitor is not initialized.");
            return new HttpData();
        }
        HttpData httpData = ((HttpMonitor)monitor).getHttpData();
        monitor.reset();
        return httpData;
    }

    public HttpsData getHttpsData() {
        Monitor monitor = this.monitors.get("HTTPS");
        if (monitor == null) {
            Log.w((String)TAG, (String)"The HTTPS monitor is not initialized.");
            return new HttpsData();
        }
        HttpsData httpsData = ((HttpsMonitor)monitor).getHttpsData();
        monitor.reset();
        return httpsData;
    }

    public QuicData getQuicData() {
        Monitor monitor = this.monitors.get("QUIC");
        if (monitor == null) {
            Log.w((String)TAG, (String)"The QUIC monitor is not initialized.");
            return new QuicData();
        }
        QuicData quicData = ((QuicMonitor)monitor).getQuicData();
        monitor.reset();
        return quicData;
    }

    public OtherTcpData getOtherTcpData() {
        Monitor monitor = this.monitors.get("OTHER_TCP");
        if (monitor == null) {
            Log.w((String)TAG, (String)"The OTHER_TCP monitor is not initialized.");
            return new OtherTcpData();
        }
        OtherTcpData otherTcpData = ((OtherTcpMonitor)monitor).getOtherTcpData();
        monitor.reset();
        return otherTcpData;
    }

    public OtherUdpData getOtherUdpData() {
        Monitor monitor = this.monitors.get("OTHER_UDP");
        if (monitor == null) {
            Log.w((String)TAG, (String)"The OTHER_UDP monitor is not initialized.");
            return new OtherUdpData();
        }
        OtherUdpData otherUdpData = ((OtherUdpMonitor)monitor).getOtherUdpData();
        monitor.reset();
        return otherUdpData;
    }

    public DnsAnswerData getDnsAnswerData() {
        if (this.dnsAnswerMonitor == null) {
            Log.w((String)TAG, (String)"The DNS monitor is not initialized.");
            return new DnsAnswerData();
        }
        HashMap<String, ArrayList<String>> domainIpsCopy = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> domainIps = this.dnsAnswerMonitor.getDomainIps();
        for (String domain : domainIps.keySet()) {
            domainIpsCopy.put(domain, new ArrayList(domainIps.get(domain)));
        }
        DnsAnswerData dnsAnswerData = new DnsAnswerData(domainIpsCopy);
        this.dnsAnswerMonitor.reset();
        return dnsAnswerData;
    }

    public void setBus(EventBus bus) {
        this.bus = bus;
    }

    public synchronized void reloadVpn() {
        Log.d((String)TAG, (String)"[reloadVpn]");
        this.stopVpn();
        this.startVpn();
    }

    private void startVpn() {
        VpnService.Builder builder = this.createBuilder();
        try {
            this.parcelFileDescriptor = builder.establish();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Android refused to start the VPN service at this moment. This is likely because of a bug in your Android version.");
        }
        this.instanciateMonitors();
        this.startNative();
        this.startPcapRecording();
    }

    private void instanciateMonitors() {
        this.monitors = new HashMap();
        this.dnsAnswerMonitor = null;
        if (this.monitorsToInstanciate == null) {
            return;
        }
        Log.d((String)TAG, (String)Arrays.toString(this.monitorsToInstanciate.toArray()));
        if (this.monitorsToInstanciate.contains("ALL") || this.monitorsToInstanciate.contains("HTTP")) {
            this.monitors.put("HTTP", new HttpMonitor());
        }
        if (this.monitorsToInstanciate.contains("ALL") || this.monitorsToInstanciate.contains("HTTPS")) {
            this.monitors.put("HTTPS", new HttpsMonitor());
        }
        if (this.monitorsToInstanciate.contains("ALL") || this.monitorsToInstanciate.contains("QUIC")) {
            this.monitors.put("QUIC", new QuicMonitor());
        }
        if (this.monitorsToInstanciate.contains("ALL") || this.monitorsToInstanciate.contains("OTHER_TCP")) {
            this.monitors.put("OTHER_TCP", new OtherTcpMonitor());
        }
        if (this.monitorsToInstanciate.contains("ALL") || this.monitorsToInstanciate.contains("OTHER_UDP")) {
            this.monitors.put("OTHER_UDP", new OtherUdpMonitor());
        }
        if (this.monitorsToInstanciate.contains("ALL") || this.monitorsToInstanciate.contains("DNS")) {
            this.dnsAnswerMonitor = new DnsAnswerMonitor();
        }
    }

    private void stopVpn() {
        if (this.parcelFileDescriptor == null) {
            return;
        }
        this.stopPcapRecording();
        this.stopNative();
        try {
            this.parcelFileDescriptor.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        finally {
            this.parcelFileDescriptor = null;
        }
    }

    private VpnService.Builder createBuilder() {
        VpnService.Builder builder = new VpnService.Builder((VpnService)this);
        builder.setSession("Netsense");
        builder.addAddress("10.1.10.1", 32);
        builder.addRoute("0.0.0.0", 0);
        builder.addRoute("0:0:0:0:0:0:0:0", 0);
        int mtu = this.getMtu();
        builder.setMtu(mtu);
        String dns1 = this.getProp("net.dns1");
        String dns2 = this.getProp("net.dns2");
        try {
            builder.addDnsServer(dns1);
            builder.addDnsServer(dns2);
        }
        catch (IllegalArgumentException e) {
            Log.w((String)TAG, (String)"dns1 or dns2 are not well formatted. Setting up default Google DNS.");
            builder.addDnsServer("8.8.8.8");
            builder.addDnsServer("8.8.4.4");
        }
        Intent intent = new Intent((Context)this, NetsenseActivity.class);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x8000000);
        builder.setConfigureIntent(pendingIntent);
        return builder;
    }

    private void startNative() {
        this.startNetGuard(this.parcelFileDescriptor.getFd(), false, 3, 2);
    }

    private void stopNative() {
        try {
            this.stopNetGuard(this.parcelFileDescriptor.getFd(), false);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
            this.stopNetGuard(-1, false);
        }
    }

    private String[] getApplicationNames(int uid, String[] packageNames) {
        if (uid == 0) {
            return new String[]{"root"};
        }
        if (uid == 1013) {
            return new String[]{"mediaserver"};
        }
        if (uid == 9999) {
            return new String[]{"nobody"};
        }
        if (packageNames == null || packageNames.length <= 0) {
            Log.w((String)TAG, (String)"packageNames == null || packageNames.length <= 0");
            return new String[]{"Unknown (" + Integer.toString(uid) + ")"};
        }
        ArrayList<String> applicationNamesList = new ArrayList<String>();
        for (String packageName : packageNames) {
            try {
                ApplicationInfo info = this.packageManager.getApplicationInfo(packageName, 0);
                applicationNamesList.add(this.packageManager.getApplicationLabel(info).toString());
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        String[] applicationNames = new String[applicationNamesList.size()];
        applicationNamesList.toArray(applicationNames);
        return applicationNames;
    }

    private String[] getPackageNames(int uid) {
        return this.packageManager.getPackagesForUid(uid);
    }

    private void handlePacket(Packet packet) {
        if (this.bus == null) {
            Log.w((String)TAG, (String)"The bus is not initialized");
            return;
        }
        this.bus.publish((Event)EventListenerTriggered.build((String)NetsenseEvent.PACKET.toString(), (Data)new PacketData(packet), null));
    }

    private void handleOutPacket(Packet packet) {
        if (this.bus == null) {
            Log.w((String)TAG, (String)"The bus is not initialized");
            return;
        }
        this.bus.publish((Event)EventListenerTriggered.build((String)NetsenseEvent.OUT_PACKET.toString(), (Data)new PacketData(packet), null));
        Object[] packageNames = this.getPackageNames(packet.uid);
        Object[] applicationNames = this.getApplicationNames(packet.uid, (String[])packageNames);
        Application application = new Application(Arrays.toString(packageNames), Arrays.toString(applicationNames));
        for (Monitor monitor : this.monitors.values()) {
            monitor.processPacket(packet, application);
        }
        this.handlePacket(packet);
    }

    public void setMonitorsToInstanciate(ArrayList<String> monitorsToInstanciate) {
        this.monitorsToInstanciate = monitorsToInstanciate;
    }

    private void handleInPacket(Packet packet) {
        if (this.bus == null) {
            Log.w((String)TAG, (String)"The bus is not initialized");
            return;
        }
        this.bus.publish((Event)EventListenerTriggered.build((String)NetsenseEvent.IN_PACKET.toString(), (Data)new PacketData(packet), null));
        this.handlePacket(packet);
    }

    private void handleDnsAnswer(DnsAnswer dnsAnswer) {
        if (this.bus == null) {
            Log.w((String)TAG, (String)"The bus is not initialized");
            return;
        }
        if (this.dnsAnswerMonitor != null) {
            this.dnsAnswerMonitor.processDnsAnswer(dnsAnswer);
        }
        this.bus.publish((Event)EventListenerTriggered.build((String)NetsenseEvent.DNS_PACKET.toString(), (Data)new DnsPacketData(dnsAnswer), null));
    }

    private void nativeExit(String reason) {
        Log.i((String)TAG, (String)("Native exit reason=" + reason));
    }

    private void networkIssue(long koCounter) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                NetsenseService.this.reloadVpn();
            }
        }, 500L);
    }

    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    public void onDestroy() {
        this.cleanup();
        super.onDestroy();
    }

    private void customUnregisterReceiver(BroadcastReceiver receiver) {
        if (receiver != null) {
            this.unregisterReceiver(receiver);
        }
    }

    private void cleanup() {
        this.stopVpn();
        this.customUnregisterReceiver(this.stopReceiver);
        this.stopReceiver = null;
        this.customUnregisterReceiver(this.idleReceiver);
        this.idleReceiver = null;
        this.customUnregisterReceiver(this.connectivityReceiver);
        this.connectivityReceiver = null;
        this.customUnregisterReceiver(this.interactiveReceiver);
        this.interactiveReceiver = null;
        this.customUnregisterReceiver(this.packageReceiver);
        this.packageReceiver = null;
        this.customUnregisterReceiver(this.statsMonitorReceiver);
        this.statsMonitorReceiver = null;
    }

    public synchronized void stopService() {
        this.cleanup();
        this.stopSelf();
    }

    static {
        System.loadLibrary("netguard");
    }

    public class NetsenseBinder
    extends Binder {
        public NetsenseService getService() {
            return NetsenseService.this;
        }
    }
}

