/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.netsense.monitor;

import android.util.Log;
import io.apisense.sting.netsense.DnsAnswer;
import java.util.ArrayList;
import java.util.HashMap;

public class DnsAnswerMonitor {
    private static final String TAG = DnsAnswerMonitor.class.getSimpleName();
    private HashMap<String, ArrayList<String>> domainIps;

    public DnsAnswerMonitor() {
        Log.d((String)TAG, (String)(TAG + " started."));
        this.domainIps = new HashMap();
    }

    public void processDnsAnswer(DnsAnswer dnsAnswer) {
        ArrayList<String> ips = this.domainIps.get(dnsAnswer.domain);
        if (ips == null) {
            ips = new ArrayList();
            ips.add(dnsAnswer.ip);
            this.domainIps.put(dnsAnswer.domain, ips);
            return;
        }
        if (ips.contains(dnsAnswer.ip)) {
            return;
        }
        ips.add(dnsAnswer.ip);
    }

    public HashMap<String, ArrayList<String>> getDomainIps() {
        return this.domainIps;
    }

    public void reset() {
        this.domainIps.clear();
    }
}

