/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.netsense.monitor;

import android.util.Log;
import io.apisense.sting.netsense.Packet;
import io.apisense.sting.netsense.data.Application;
import io.apisense.sting.netsense.data.other.tcp.FirstOtherTcpApplication;
import io.apisense.sting.netsense.data.other.tcp.OtherTcpData;
import io.apisense.sting.netsense.monitor.HttpMonitor;
import io.apisense.sting.netsense.monitor.HttpsMonitor;
import io.apisense.sting.netsense.monitor.Monitor;
import java.util.ArrayList;
import java.util.HashMap;

public class OtherTcpMonitor
implements Monitor {
    private static final String TAG = OtherTcpMonitor.class.getSimpleName();
    private int nbFirstOtherTcpPackets;
    private HashMap<String, Integer> nbFirstOtherTcpPacketsForIps;
    private HashMap<Application, Integer> nbFirstOtherTcpPacketsForApplications;

    public OtherTcpMonitor() {
        Log.d((String)TAG, (String)(TAG + " started."));
        this.nbFirstOtherTcpPacketsForIps = new HashMap();
        this.nbFirstOtherTcpPacketsForApplications = new HashMap();
    }

    @Override
    public void processPacket(Packet packet, Application application) {
        if (!this.isOtherTcp(packet)) {
            return;
        }
        if (packet.first) {
            this.incNbFirstOtherTcpPackets();
            this.incNbFirstOtherTcpPacketsForApplication(application);
            this.incNbFirstOtherTcpPacketsForIp(packet.daddr);
        }
    }

    private void incNbFirstOtherTcpPackets() {
        ++this.nbFirstOtherTcpPackets;
    }

    private void incNbFirstOtherTcpPacketsForApplication(Application application) {
        Integer nbFirstOtherTcpPacketsForApplication = this.nbFirstOtherTcpPacketsForApplications.get(application);
        if (nbFirstOtherTcpPacketsForApplication != null) {
            this.nbFirstOtherTcpPacketsForApplications.put(application, nbFirstOtherTcpPacketsForApplication + 1);
            return;
        }
        this.nbFirstOtherTcpPacketsForApplications.put(application, 1);
    }

    private void incNbFirstOtherTcpPacketsForIp(String ip) {
        Integer nbFirstOtherTcpPacketsForIp = this.nbFirstOtherTcpPacketsForIps.get(ip);
        if (nbFirstOtherTcpPacketsForIp != null) {
            this.nbFirstOtherTcpPacketsForIps.put(ip, nbFirstOtherTcpPacketsForIp + 1);
            return;
        }
        this.nbFirstOtherTcpPacketsForIps.put(ip, 1);
    }

    public OtherTcpData getOtherTcpData() {
        ArrayList<FirstOtherTcpApplication> nbFrstthrTcpPcktsFrpplctns = new ArrayList<FirstOtherTcpApplication>();
        for (Application application : this.nbFirstOtherTcpPacketsForApplications.keySet()) {
            nbFrstthrTcpPcktsFrpplctns.add(new FirstOtherTcpApplication(application, this.nbFirstOtherTcpPacketsForApplications.get(application)));
        }
        HashMap<String, Integer> nbFrstthrTcpPcktsFrps = new HashMap<String, Integer>(this.nbFirstOtherTcpPacketsForIps);
        return new OtherTcpData(this.nbFirstOtherTcpPackets, nbFrstthrTcpPcktsFrpplctns, nbFrstthrTcpPcktsFrps);
    }

    @Override
    public void reset() {
        this.nbFirstOtherTcpPackets = 0;
        this.nbFirstOtherTcpPacketsForApplications.clear();
        this.nbFirstOtherTcpPacketsForIps.clear();
    }

    private boolean isOtherTcp(Packet packet) {
        return !HttpMonitor.isHttp(packet) && !HttpsMonitor.isHttps(packet) && packet.protocol == 6;
    }
}

