/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.netsense.monitor;

import android.util.Log;
import io.apisense.sting.netsense.Packet;
import io.apisense.sting.netsense.data.Application;
import io.apisense.sting.netsense.data.other.udp.FirstOtherUdpApplication;
import io.apisense.sting.netsense.data.other.udp.OtherUdpData;
import io.apisense.sting.netsense.monitor.Monitor;
import io.apisense.sting.netsense.monitor.QuicMonitor;
import java.util.ArrayList;
import java.util.HashMap;

public class OtherUdpMonitor
implements Monitor {
    private static final String TAG = OtherUdpMonitor.class.getSimpleName();
    private int nbFirstOtherUdpPackets;
    private HashMap<String, Integer> nbFirstOtherUdpPacketsForIps;
    private HashMap<Application, Integer> nbFirstOtherUdpPacketsForApplications;

    public OtherUdpMonitor() {
        Log.d((String)TAG, (String)(TAG + " started."));
        this.nbFirstOtherUdpPacketsForIps = new HashMap();
        this.nbFirstOtherUdpPacketsForApplications = new HashMap();
    }

    @Override
    public void processPacket(Packet packet, Application application) {
        if (!this.isOtherUdp(packet)) {
            return;
        }
        if (packet.first) {
            this.incNbFirstOtherUdpPackets();
            this.incNbFirstOtherUdpPacketsForApplication(application);
            this.incNbFirstOtherUdpPacketsForIp(packet.daddr);
        }
    }

    private void incNbFirstOtherUdpPackets() {
        ++this.nbFirstOtherUdpPackets;
    }

    private void incNbFirstOtherUdpPacketsForApplication(Application application) {
        Integer nbFirstOtherUdpPacketsForApplication = this.nbFirstOtherUdpPacketsForApplications.get(application);
        if (nbFirstOtherUdpPacketsForApplication != null) {
            this.nbFirstOtherUdpPacketsForApplications.put(application, nbFirstOtherUdpPacketsForApplication + 1);
            return;
        }
        this.nbFirstOtherUdpPacketsForApplications.put(application, 1);
    }

    private void incNbFirstOtherUdpPacketsForIp(String ip) {
        Integer nbFirstOtherUdpPacketsForIp = this.nbFirstOtherUdpPacketsForIps.get(ip);
        if (nbFirstOtherUdpPacketsForIp != null) {
            this.nbFirstOtherUdpPacketsForIps.put(ip, nbFirstOtherUdpPacketsForIp + 1);
            return;
        }
        this.nbFirstOtherUdpPacketsForIps.put(ip, 1);
    }

    public OtherUdpData getOtherUdpData() {
        ArrayList<FirstOtherUdpApplication> nbFrstthrUdpPcktsFrpplctns = new ArrayList<FirstOtherUdpApplication>();
        for (Application application : this.nbFirstOtherUdpPacketsForApplications.keySet()) {
            nbFrstthrUdpPcktsFrpplctns.add(new FirstOtherUdpApplication(application, this.nbFirstOtherUdpPacketsForApplications.get(application)));
        }
        HashMap<String, Integer> nbFrstthrUdpPcktsFrps = new HashMap<String, Integer>(this.nbFirstOtherUdpPacketsForIps);
        return new OtherUdpData(this.nbFirstOtherUdpPackets, nbFrstthrUdpPcktsFrpplctns, nbFrstthrUdpPcktsFrps);
    }

    @Override
    public void reset() {
        this.nbFirstOtherUdpPackets = 0;
        this.nbFirstOtherUdpPacketsForApplications.clear();
        this.nbFirstOtherUdpPacketsForIps.clear();
    }

    private boolean isOtherUdp(Packet packet) {
        return !QuicMonitor.isQuic(packet) && packet.protocol == 17;
    }
}

