/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.netsense.monitor;

import android.util.Log;
import io.apisense.sting.netsense.Packet;
import io.apisense.sting.netsense.data.Application;
import io.apisense.sting.netsense.data.quic.FirstQuicApplication;
import io.apisense.sting.netsense.data.quic.QuicData;
import io.apisense.sting.netsense.monitor.Monitor;
import java.util.ArrayList;
import java.util.HashMap;

public class QuicMonitor
implements Monitor {
    private static final String TAG = QuicMonitor.class.getSimpleName();
    private int nbFirstQuicPackets;
    private HashMap<String, Integer> nbFirstQuicPacketsForIps;
    private HashMap<Application, Integer> nbFirstQuicPacketsForApplications;

    public QuicMonitor() {
        Log.d((String)TAG, (String)(TAG + " started."));
        this.nbFirstQuicPacketsForIps = new HashMap();
        this.nbFirstQuicPacketsForApplications = new HashMap();
    }

    @Override
    public void processPacket(Packet packet, Application application) {
        if (!QuicMonitor.isQuic(packet)) {
            return;
        }
        if (packet.first) {
            this.incNbFirstQuicPackets();
            this.incNbFirstQuicPacketsForApplication(application);
            this.incNbFirstQuicPacketsForIp(packet.daddr);
        }
    }

    private void incNbFirstQuicPackets() {
        ++this.nbFirstQuicPackets;
    }

    private void incNbFirstQuicPacketsForApplication(Application application) {
        Integer nbFirstQuicPacketsForApplication = this.nbFirstQuicPacketsForApplications.get(application);
        if (nbFirstQuicPacketsForApplication != null) {
            this.nbFirstQuicPacketsForApplications.put(application, nbFirstQuicPacketsForApplication + 1);
            return;
        }
        this.nbFirstQuicPacketsForApplications.put(application, 1);
    }

    private void incNbFirstQuicPacketsForIp(String ip) {
        Integer nbFirstQuicPacketsForIp = this.nbFirstQuicPacketsForIps.get(ip);
        if (nbFirstQuicPacketsForIp != null) {
            this.nbFirstQuicPacketsForIps.put(ip, nbFirstQuicPacketsForIp + 1);
            return;
        }
        this.nbFirstQuicPacketsForIps.put(ip, 1);
    }

    public QuicData getQuicData() {
        ArrayList<FirstQuicApplication> nbFrstQcPcktsFrpplctns = new ArrayList<FirstQuicApplication>();
        for (Application application : this.nbFirstQuicPacketsForApplications.keySet()) {
            nbFrstQcPcktsFrpplctns.add(new FirstQuicApplication(application, this.nbFirstQuicPacketsForApplications.get(application)));
        }
        HashMap<String, Integer> nbFrstQcPcktsFrps = new HashMap<String, Integer>(this.nbFirstQuicPacketsForIps);
        return new QuicData(this.nbFirstQuicPackets, nbFrstQcPcktsFrpplctns, nbFrstQcPcktsFrps);
    }

    @Override
    public void reset() {
        this.nbFirstQuicPackets = 0;
        this.nbFirstQuicPacketsForApplications.clear();
        this.nbFirstQuicPacketsForIps.clear();
    }

    public static boolean isQuic(Packet packet) {
        return packet.protocol == 17 && (packet.dport == 443 || packet.sport == 443 || packet.dport == 80 || packet.sport == 80);
    }
}

