/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.call;

import io.apisense.dart.lib.BitMask;
import java.util.EnumSet;

public enum CallEvent {
    CALL_ENDED("call:call:ended");

    private final int value = 1 << this.ordinal();
    private final String label;

    private CallEvent(String label) {
        this.label = label;
    }

    public int value() {
        return this.value;
    }

    public final boolean matches(int value) {
        return BitMask.matches((int)this.value, (int)value);
    }

    public final boolean equals(String label) {
        return this.label.equalsIgnoreCase(label);
    }

    public final String toString() {
        return this.label;
    }

    public static final EnumSet<CallEvent> parse(String ... labels) {
        EnumSet<CallEvent> res = EnumSet.noneOf(CallEvent.class);
        for (String label : labels) {
            for (CallEvent val : CallEvent.values()) {
                if (!val.equals(label)) continue;
                res.add(val);
            }
        }
        return res;
    }

    public static final EnumSet<CallEvent> parse(int ... codes) {
        EnumSet<CallEvent> res = EnumSet.noneOf(CallEvent.class);
        for (int code : codes) {
            for (CallEvent val : CallEvent.values()) {
                if (!val.matches(code)) continue;
                res.add(val);
            }
        }
        return res;
    }
}

