/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.cpu;

import io.apisense.dart.api.Seed;
import io.apisense.dart.lib.BitMask;
import java.util.EnumSet;

public enum CpuSeed implements Seed
{
    TIMESTAMP("timestamp", Long.class),
    PROCESSOR("processor", String.class),
    CPUCORES("cpucores", Integer.class),
    CPUIMPLEMENTER("cpuimplementer", String.class),
    CPUARCHITECTURE("cpuarchitecture", Integer.class),
    CPUVARIANT("cpuvariant", String.class),
    CPUPART("cpupart", String.class),
    CPUREVISION("cpurevision", Integer.class),
    HARDWARE("hardware", String.class),
    REVISION("revision", Integer.class),
    SERIAL("serial", String.class);

    private final int value = 1 << this.ordinal();
    private final String label;
    private final Class type;

    private CpuSeed(String label, Class type) {
        this.label = label;
        this.type = type;
    }

    public int value() {
        return this.value;
    }

    public Class type() {
        return this.type;
    }

    public final boolean matches(int value) {
        return BitMask.matches((int)this.value, (int)value);
    }

    public final boolean equals(String label) {
        return this.label.equalsIgnoreCase(label);
    }

    public final String toString() {
        return this.label;
    }

    public static final EnumSet<CpuSeed> parse(String ... labels) {
        EnumSet<CpuSeed> res = EnumSet.noneOf(CpuSeed.class);
        for (String label : labels) {
            for (CpuSeed val : CpuSeed.values()) {
                if (!val.equals(label)) continue;
                res.add(val);
            }
        }
        return res;
    }

    public static final EnumSet<CpuSeed> parse(int ... codes) {
        EnumSet<CpuSeed> res = EnumSet.noneOf(CpuSeed.class);
        for (int code : codes) {
            for (CpuSeed val : CpuSeed.values()) {
                if (!val.matches(code)) continue;
                res.add(val);
            }
        }
        return res;
    }
}

