/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.system;

import io.apisense.dart.api.Seed;
import io.apisense.dart.lib.BitMask;
import io.apisense.dart.system.SystemLock;
import io.apisense.dart.system.SystemScreen;
import java.util.EnumSet;
import java.util.List;

public enum SystemSeed implements Seed
{
    TIMESTAMP("timestamp", Long.class),
    FOREGROUND("foreground", String.class),
    SERVICES("services", List.class),
    SCREEN("screen", SystemScreen.class),
    LOCK("lock", SystemLock.class);

    private final int value = 1 << this.ordinal();
    private final String label;
    private final Class type;

    private SystemSeed(String label, Class type) {
        this.label = label;
        this.type = type;
    }

    public int value() {
        return this.value;
    }

    public Class type() {
        return this.type;
    }

    public final boolean matches(int value) {
        return BitMask.matches((int)this.value, (int)value);
    }

    public final boolean equals(String label) {
        return this.label.equalsIgnoreCase(label);
    }

    public final String toString() {
        return this.label;
    }

    public static final EnumSet<SystemSeed> parse(String ... labels) {
        EnumSet<SystemSeed> res = EnumSet.noneOf(SystemSeed.class);
        for (String label : labels) {
            for (SystemSeed val : SystemSeed.values()) {
                if (!val.equals(label)) continue;
                res.add(val);
            }
        }
        return res;
    }

    public static final EnumSet<SystemSeed> parse(int ... codes) {
        EnumSet<SystemSeed> res = EnumSet.noneOf(SystemSeed.class);
        for (int code : codes) {
            for (SystemSeed val : SystemSeed.values()) {
                if (!val.matches(code)) continue;
                res.add(val);
            }
        }
        return res;
    }
}

