/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone;

import io.apisense.dart.cpu.CpuDartSkel;
import io.apisense.dart.cpu.CpuData;
import io.apisense.dart.cpu.CpuSeed;
import io.apisense.dart.lib.EventBus;
import io.apisense.sting.lib.Sensor;
import io.apisense.sting.phone.R;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.EnumSet;
import javax.inject.Inject;

public class CpuSting
extends CpuDartSkel {
    public static final Sensor SENSOR_DESCRIPTION = new Sensor("CPU info", "cpu", "Retrieve information about the CPU.", R.drawable.aps_cpu, new String[0]);
    private final CpuData cpuData = CpuSting.readCPUInfoFile();

    @Inject
    protected CpuSting(EventBus bus) {
        super(bus, EnumSet.allOf(CpuSeed.class));
    }

    @Override
    public String processor() {
        return this.cpuData.processor;
    }

    @Override
    public Integer cpucores() {
        return this.cpuData.cpucores;
    }

    @Override
    public String cpuimplementer() {
        return this.cpuData.cpuimplementer;
    }

    @Override
    public Integer cpuarchitecture() {
        return this.cpuData.cpuarchitecture;
    }

    @Override
    public String cpuvariant() {
        return this.cpuData.cpuvariant;
    }

    @Override
    public String cpupart() {
        return this.cpuData.cpupart;
    }

    @Override
    public Integer cpurevision() {
        return this.cpuData.cpurevision;
    }

    @Override
    public String hardware() {
        return this.cpuData.hardware;
    }

    @Override
    public Integer revision() {
        return this.cpuData.revision;
    }

    @Override
    public String serial() {
        return this.cpuData.serial;
    }

    private static CpuData readCPUInfoFile() {
        File file = new File("/proc/cpuinfo");
        String processor = null;
        int cpuCores = 0;
        String cpuImplementer = null;
        int cpuArchitecture = 0;
        String cpuVariant = null;
        String cpuPart = null;
        int cpuRevision = 0;
        String hardware = null;
        int revision = 0;
        String serial = null;
        try {
            String line;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                String[] keyValuePair = line.split(":");
                if (keyValuePair.length < 2) continue;
                String keyword = keyValuePair[0].trim();
                String value = keyValuePair[1].trim();
                if (keyword == null || keyword.isEmpty()) continue;
                switch (keyword) {
                    case "Processor": {
                        processor = value;
                        break;
                    }
                    case "processor": {
                        ++cpuCores;
                        break;
                    }
                    case "CPU implementer": {
                        cpuImplementer = value;
                        break;
                    }
                    case "CPU architecture": {
                        cpuArchitecture = Integer.parseInt(value);
                        break;
                    }
                    case "CPU variant": {
                        cpuVariant = value;
                        break;
                    }
                    case "CPU part": {
                        cpuPart = value;
                        break;
                    }
                    case "CPU revision": {
                        cpuRevision = Integer.parseInt(value);
                        break;
                    }
                    case "Hardware": {
                        hardware = value;
                        break;
                    }
                    case "Revision": {
                        revision = Integer.parseInt(value);
                        break;
                    }
                    case "Serial": {
                        serial = value;
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            return new CpuData(0, null, 0, null, 0, null, null, 0, null, 0, null);
        }
        return new CpuData(0, processor, cpuCores, cpuImplementer, cpuArchitecture, cpuVariant, cpuPart, cpuRevision, hardware, revision, serial);
    }
}

