/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import android.view.WindowManager;
import io.apisense.dart.lib.EventBus;
import io.apisense.dart.lib.EventFilter;
import io.apisense.dart.lib.Tokens;
import io.apisense.dart.system.SystemDartSkel;
import io.apisense.dart.system.SystemData;
import io.apisense.dart.system.SystemEvent;
import io.apisense.dart.system.SystemLock;
import io.apisense.dart.system.SystemScreen;
import io.apisense.dart.system.SystemSeed;
import io.apisense.sting.lib.Sensor;
import io.apisense.sting.phone.R;
import io.apisense.sting.phone.system.ScreenStateReceiver;
import io.apisense.sting.phone.system.Service;
import io.apisense.sting.phone.system.TopActivityFinder;
import io.apisense.sting.phone.system.WindowChangeDetectingService;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;

public class SystemSting
extends SystemDartSkel {
    private static final String TAG = "APS/system";
    public static final Sensor SENSOR_DESCRIPTION = new Sensor("System info", "system", "Gives info about the system state.", R.drawable.aps_system, new String[0]);
    private final Context context;
    private final TopActivityFinder topActivityFinder;

    @Inject
    protected SystemSting(EventBus bus, Context context) {
        super(bus, EnumSet.allOf(SystemSeed.class));
        this.context = context;
        this.topActivityFinder = new TopActivityFinder(context);
    }

    @Override
    public String foreground() {
        return this.topActivityFinder.findTopPackage();
    }

    @Override
    public List<Service> services() {
        ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
        return this.checkServices(activityManager);
    }

    private List<Service> checkServices(ActivityManager manager) {
        List services = manager.getRunningServices(Integer.MAX_VALUE);
        ArrayList<Service> serviceList = new ArrayList<Service>(services.size());
        for (ActivityManager.RunningServiceInfo service : services) {
            serviceList.add(new Service(service.process, service.clientPackage, service.activeSince, service.foreground, service.started));
        }
        return serviceList;
    }

    @Override
    public String lock() {
        KeyguardManager kgManager = (KeyguardManager)this.context.getSystemService("keyguard");
        return this.checkLocked(kgManager).toString();
    }

    private SystemLock checkLocked(KeyguardManager manager) {
        if (Build.VERSION.SDK_INT >= 16) {
            if (!manager.isKeyguardSecure()) {
                return SystemLock.NOT_SECURED;
            }
            return manager.isKeyguardLocked() ? SystemLock.LOCKED : SystemLock.UNLOCKED;
        }
        return manager.inKeyguardRestrictedInputMode() ? SystemLock.LOCKED : SystemLock.UNLOCKED;
    }

    @Override
    public String screen() {
        WindowManager winMan = (WindowManager)this.context.getSystemService("window");
        return this.checkScreen(winMan).toString();
    }

    private SystemScreen checkScreen(WindowManager manager) {
        if (Build.VERSION.SDK_INT >= 20) {
            switch (manager.getDefaultDisplay().getState()) {
                case 1: {
                    return SystemScreen.OFF;
                }
                case 2: 
                case 3: 
                case 4: {
                    return SystemScreen.ON;
                }
            }
            return SystemScreen.UNKNOWN;
        }
        PowerManager powerManager = (PowerManager)this.context.getSystemService("power");
        return powerManager.isScreenOn() ? SystemScreen.ON : SystemScreen.OFF;
    }

    @Override
    protected Tokens.TokensListener<Void> initScreenUnlockedListener() {
        return new ScreenListener(){

            @Override
            protected ScreenStateReceiver getBroadcastReceiver() {
                return new ScreenStateReceiver(){

                    @Override
                    protected void onScreenUnlocked() {
                        this.sendData();
                    }

                    @Override
                    public void onScreenOn() {
                    }

                    @Override
                    public void onScreenOff() {
                    }
                };
            }

            @Override
            protected IntentFilter getIntentFilter() {
                return new IntentFilter("android.intent.action.USER_PRESENT");
            }

            @Override
            protected SystemEvent getEvent() {
                return SystemEvent.SCREEN_UNLOCKED;
            }
        };
    }

    @Override
    protected Tokens.TokensListener<Void> initScreenStateChangedListener() {
        return new ScreenListener(){

            @Override
            protected ScreenStateReceiver getBroadcastReceiver() {
                return new ScreenStateReceiver(){

                    @Override
                    protected void onScreenUnlocked() {
                    }

                    @Override
                    public void onScreenOn() {
                        this.sendData();
                    }

                    @Override
                    public void onScreenOff() {
                        this.sendData();
                    }
                };
            }

            @Override
            protected IntentFilter getIntentFilter() {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_OFF");
                intentFilter.addAction("android.intent.action.SCREEN_ON");
                return intentFilter;
            }

            @Override
            protected SystemEvent getEvent() {
                return SystemEvent.SCREENSTATE_CHANGED;
            }
        };
    }

    @Override
    protected Tokens.TokensListener<Void> initForegroundAppChangedListener() {
        return new Tokens.TokensListener<Void>(){
            private WindowChangeDetectingService.OnTopWindowChanged callback;

            public void init() {
            }

            public String computeTopic(EventFilter<Void> eventFilter) {
                if (this.callback == null) {
                    this.callback = new WindowChangeDetectingService.OnTopWindowChanged(){

                        @Override
                        public void newTopApplication(String applicationName) {
                            SystemSting.this.publish(SystemEvent.FOREGROUNDAPP_CHANGED, (SystemData)SystemSting.this.data());
                        }
                    };
                    WindowChangeDetectingService.addCallback(this.callback);
                }
                return SystemEvent.FOREGROUNDAPP_CHANGED.toString();
            }

            public void discardFilter(EventFilter<Void> eventFilter) {
                if (this.callback != null) {
                    WindowChangeDetectingService.removeCallback(this.callback);
                }
            }

            public void release() {
            }
        };
    }

    private abstract class ScreenListener
    implements Tokens.TokensListener<Void> {
        private BroadcastReceiver receiver;

        private ScreenListener() {
        }

        public void init() {
        }

        public String computeTopic(EventFilter<Void> eventFilter) {
            if (this.receiver == null) {
                this.receiver = this.getBroadcastReceiver();
                SystemSting.this.context.registerReceiver(this.receiver, this.getIntentFilter());
            }
            return this.getEvent().toString();
        }

        public void discardFilter(EventFilter<Void> eventFilter) {
            if (this.receiver != null) {
                SystemSting.this.context.unregisterReceiver(this.receiver);
                this.receiver = null;
            }
        }

        public void release() {
        }

        protected void sendData() {
            SystemSting.this.publish(this.getEvent(), (SystemData)SystemSting.this.data());
        }

        protected abstract BroadcastReceiver getBroadcastReceiver();

        protected abstract IntentFilter getIntentFilter();

        protected abstract SystemEvent getEvent();
    }
}

