/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone.storage;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import io.apisense.sting.phone.storage.StorageEntry;
import java.sql.SQLException;

class LocalStoreDBHelper
extends OrmLiteSqliteOpenHelper {
    private static final String TAG = "LocalStoreDBHelper";
    private static final int DATABASE_VERSION = 1;
    private Dao<StorageEntry, Long> jsonDao;

    LocalStoreDBHelper(Context context, String cropSlug) {
        super(context, LocalStoreDBHelper.dbName(cropSlug), null, 1);
    }

    private static String dbName(String cropSlug) {
        return "local_" + cropSlug + ".sqlite";
    }

    public void dropDatabase() throws SQLException {
        TableUtils.clearTable((ConnectionSource)this.connectionSource, StorageEntry.class);
    }

    public Dao<StorageEntry, Long> getDao() throws SQLException {
        if (this.jsonDao == null) {
            this.jsonDao = this.getDao(StorageEntry.class);
        }
        return this.jsonDao;
    }

    public void onCreate(SQLiteDatabase database, ConnectionSource connectionSource) {
        try {
            TableUtils.createTable((ConnectionSource)connectionSource, StorageEntry.class);
        }
        catch (SQLException e) {
            Log.e((String)TAG, (String)"Can't create database", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void onUpgrade(SQLiteDatabase database, ConnectionSource connectionSource, int oldVersion, int newVersion) {
    }
}

