/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.call;

import io.apisense.dart.api.Seed;
import io.apisense.dart.lib.BitMask;
import java.util.EnumSet;
import java.util.List;

public enum CallSeed implements Seed
{
    TIMESTAMP("timestamp", Long.class),
    DURATION("duration", Long.class),
    CONTACT("contact", String.class),
    CARRIER("carrier", String.class),
    NEIGHBOURINGCELLS("neighbouringCells", List.class);

    private final int value = 1 << this.ordinal();
    private final String label;
    private final Class type;

    private CallSeed(String label, Class type) {
        this.label = label;
        this.type = type;
    }

    public int value() {
        return this.value;
    }

    public Class type() {
        return this.type;
    }

    public final boolean matches(int value) {
        return BitMask.matches((int)this.value, (int)value);
    }

    public final boolean equals(String label) {
        return this.label.equalsIgnoreCase(label);
    }

    public final String toString() {
        return this.label;
    }

    public static final EnumSet<CallSeed> parse(String ... labels) {
        EnumSet<CallSeed> res = EnumSet.noneOf(CallSeed.class);
        for (String label : labels) {
            for (CallSeed val : CallSeed.values()) {
                if (!val.equals(label)) continue;
                res.add(val);
            }
        }
        return res;
    }

    public static final EnumSet<CallSeed> parse(int ... codes) {
        EnumSet<CallSeed> res = EnumSet.noneOf(CallSeed.class);
        for (int code : codes) {
            for (CallSeed val : CallSeed.values()) {
                if (!val.matches(code)) continue;
                res.add(val);
            }
        }
        return res;
    }
}

