/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.device;

import io.apisense.dart.api.Seed;
import io.apisense.dart.lib.BitMask;
import java.util.EnumSet;

public enum DeviceSeed implements Seed
{
    TIMESTAMP("timestamp", Long.class),
    MANUFACTURER("manufacturer", String.class),
    MODEL("model", String.class),
    OS("os", String.class),
    VERSION("version", String.class),
    SCREENSIZE("screenSize", Double.class),
    RESOLUTION("resolution", String.class),
    ROTATION("rotation", Integer.class);

    private final int value = 1 << this.ordinal();
    private final String label;
    private final Class type;

    private DeviceSeed(String label, Class type) {
        this.label = label;
        this.type = type;
    }

    public int value() {
        return this.value;
    }

    public Class type() {
        return this.type;
    }

    public final boolean matches(int value) {
        return BitMask.matches((int)this.value, (int)value);
    }

    public final boolean equals(String label) {
        return this.label.equalsIgnoreCase(label);
    }

    public final String toString() {
        return this.label;
    }

    public static final EnumSet<DeviceSeed> parse(String ... labels) {
        EnumSet<DeviceSeed> res = EnumSet.noneOf(DeviceSeed.class);
        for (String label : labels) {
            for (DeviceSeed val : DeviceSeed.values()) {
                if (!val.equals(label)) continue;
                res.add(val);
            }
        }
        return res;
    }

    public static final EnumSet<DeviceSeed> parse(int ... codes) {
        EnumSet<DeviceSeed> res = EnumSet.noneOf(DeviceSeed.class);
        for (int code : codes) {
            for (DeviceSeed val : DeviceSeed.values()) {
                if (!val.matches(code)) continue;
                res.add(val);
            }
        }
        return res;
    }
}

