/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.localstorage;

import io.apisense.dart.api.Seed;
import io.apisense.dart.lib.BitMask;
import java.util.EnumSet;

public enum LocalStorageSeed implements Seed
{
    TIMESTAMP("timestamp", Long.class);

    private final int value = 1 << this.ordinal();
    private final String label;
    private final Class type;

    private LocalStorageSeed(String label, Class type) {
        this.label = label;
        this.type = type;
    }

    public int value() {
        return this.value;
    }

    public Class type() {
        return this.type;
    }

    public final boolean matches(int value) {
        return BitMask.matches((int)this.value, (int)value);
    }

    public final boolean equals(String label) {
        return this.label.equalsIgnoreCase(label);
    }

    public final String toString() {
        return this.label;
    }

    public static final EnumSet<LocalStorageSeed> parse(String ... labels) {
        EnumSet<LocalStorageSeed> res = EnumSet.noneOf(LocalStorageSeed.class);
        for (String label : labels) {
            for (LocalStorageSeed val : LocalStorageSeed.values()) {
                if (!val.equals(label)) continue;
                res.add(val);
            }
        }
        return res;
    }

    public static final EnumSet<LocalStorageSeed> parse(int ... codes) {
        EnumSet<LocalStorageSeed> res = EnumSet.noneOf(LocalStorageSeed.class);
        for (int code : codes) {
            for (LocalStorageSeed val : LocalStorageSeed.values()) {
                if (!val.matches(code)) continue;
                res.add(val);
            }
        }
        return res;
    }
}

