/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import io.apisense.dart.device.DeviceDartSkel;
import io.apisense.dart.device.DeviceSeed;
import io.apisense.dart.lib.EventBus;
import io.apisense.sting.lib.Sensor;
import io.apisense.sting.phone.R;
import java.util.EnumSet;
import javax.inject.Inject;

public class DeviceSting
extends DeviceDartSkel {
    public static final Sensor SENSOR_DESCRIPTION = new Sensor("Device info", "device", "Retrieve common information about your phone.", R.drawable.aps_device, new String[0]);
    private final WindowManager winMan;
    private final DisplayMetrics displayMetrics;

    @Inject
    protected DeviceSting(EventBus bus, Context context) {
        super(bus, EnumSet.allOf(DeviceSeed.class));
        this.winMan = (WindowManager)context.getSystemService("window");
        this.displayMetrics = new DisplayMetrics();
    }

    @Override
    public String manufacturer() {
        return Build.MANUFACTURER;
    }

    @Override
    public String model() {
        return Build.MODEL;
    }

    @Override
    public String os() {
        return "Android";
    }

    @Override
    public String version() {
        return Build.VERSION.RELEASE;
    }

    @Override
    public Double screenSize() {
        this.winMan.getDefaultDisplay().getMetrics(this.displayMetrics);
        int dens = this.displayMetrics.densityDpi;
        double wi = (double)this.displayMetrics.widthPixels / (double)dens;
        double hi = (double)this.displayMetrics.heightPixels / (double)dens;
        double x = Math.pow(wi, 2.0);
        double y = Math.pow(hi, 2.0);
        return Math.sqrt(x + y);
    }

    @Override
    public String resolution() {
        DisplayMetrics dm = new DisplayMetrics();
        this.winMan.getDefaultDisplay().getMetrics(dm);
        return dm.heightPixels + "x" + dm.widthPixels;
    }

    @Override
    public Integer rotation() {
        switch (this.winMan.getDefaultDisplay().getRotation()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return null;
    }
}

