{
    "name": "system",
    "type": "dart",
    "description": "Monitors device state.",
    "seeds": [
        {
            "name": "foreground",
            "description": "Name of the foreground application",
            "type": "string"
        },
        {
            "name": "services",
            "description": "Services running on the device.",
            "type": "List<io.apisense.sting.phone.system.Service>"
        },
        {
            "name": "screen",
            "description": "Current illumination state of the screen",
            "type": ["ON", "OFF", "UNKNOWN"]
        },
        {
            "name": "lock",
            "description": "Current locking state of the screen, NOT_SECURED means that no protection is set",
            "type": ["LOCKED", "UNLOCKED", "NOT_SECURED"]
        }
    ],
    "sprouts": [
        {
            "event": "screen:unlocked",
            "description": "Send an event when the device is locked or unlocked"
        },
        {
            "event": "screenState:changed",
            "description": "Send an event when the screen is turned on or off"
        },
        {
            "event": "foregroundApp:changed",
            "description": "Send an event when the user changes the foreground app"
        }
    ]
}
