/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.memory;

import io.apisense.dart.api.Seed;
import io.apisense.dart.lib.BitMask;
import java.util.EnumSet;

public enum MemorySeed implements Seed
{
    TIMESTAMP("timestamp", Long.class),
    MEMTOTAL("memtotal", Integer.class),
    MEMFREE("memfree", Integer.class),
    BUFFERS("buffers", Integer.class),
    CACHED("cached", Integer.class),
    SWAPCACHED("swapcached", Integer.class),
    ACTIVE("active", Integer.class),
    INACTIVE("inactive", Integer.class),
    ACTIVEANON("activeanon", Integer.class),
    INACTIVEANON("inactiveanon", Integer.class),
    ACTIVEFILE("activefile", Integer.class),
    INACTIVEFILE("inactivefile", Integer.class),
    UNEVICTABLE("unevictable", Integer.class),
    MLOCKED("mlocked", Integer.class),
    HIGHTOTAL("hightotal", Integer.class),
    HIGHFREE("highfree", Integer.class),
    LOWTOTAL("lowtotal", Integer.class),
    LOWFREE("lowfree", Integer.class),
    SWAPTOTAL("swaptotal", Integer.class),
    SWAPFREE("swapfree", Integer.class),
    DIRTY("dirty", Integer.class),
    WRITEBACK("writeback", Integer.class),
    ANONPAGES("anonpages", Integer.class),
    MAPPED("mapped", Integer.class),
    SHMEM("shmem", Integer.class),
    SLAB("slab", Integer.class),
    SRECLAIMABLE("sreclaimable", Integer.class),
    SUNRECLAIMABLE("sunreclaimable", Integer.class),
    KERNELSTACK("kernelstack", Integer.class),
    PAGETABLES("pagetables", Integer.class),
    NFSUNSTABLE("nfsunstable", Integer.class),
    BOUNCE("bounce", Integer.class),
    WRITEBACKTMP("writebacktmp", Integer.class),
    COMMITLIMIT("commitlimit", Integer.class),
    COMMITTEDAS("committedas", Integer.class),
    VMALLOCTOTAL("vmalloctotal", Integer.class),
    VMALLOCUSED("vmallocused", Integer.class),
    VMALLOCCHUNCK("vmallocchunck", Integer.class);

    private final int value = 1 << this.ordinal();
    private final String label;
    private final Class type;

    private MemorySeed(String label, Class type) {
        this.label = label;
        this.type = type;
    }

    public int value() {
        return this.value;
    }

    public Class type() {
        return this.type;
    }

    public final boolean matches(int value) {
        return BitMask.matches((int)this.value, (int)value);
    }

    public final boolean equals(String label) {
        return this.label.equalsIgnoreCase(label);
    }

    public final String toString() {
        return this.label;
    }

    public static final EnumSet<MemorySeed> parse(String ... labels) {
        EnumSet<MemorySeed> res = EnumSet.noneOf(MemorySeed.class);
        for (String label : labels) {
            for (MemorySeed val : MemorySeed.values()) {
                if (!val.equals(label)) continue;
                res.add(val);
            }
        }
        return res;
    }

    public static final EnumSet<MemorySeed> parse(int ... codes) {
        EnumSet<MemorySeed> res = EnumSet.noneOf(MemorySeed.class);
        for (int code : codes) {
            for (MemorySeed val : MemorySeed.values()) {
                if (!val.matches(code)) continue;
                res.add(val);
            }
        }
        return res;
    }
}

