/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.system;

import io.apisense.dart.lib.BitMask;
import java.util.EnumSet;

public enum SystemScreen {
    ON("ON"),
    OFF("OFF"),
    UNKNOWN("UNKNOWN");

    private final int value = 1 << this.ordinal();
    private final String label;

    private SystemScreen(String label) {
        this.label = label;
    }

    public int value() {
        return this.value;
    }

    public final boolean matches(int value) {
        return BitMask.matches((int)this.value, (int)value);
    }

    public final boolean equals(String label) {
        return this.label.equalsIgnoreCase(label);
    }

    public final String toString() {
        return this.label;
    }

    public static final SystemScreen parse(String label) {
        for (SystemScreen val : SystemScreen.values()) {
            if (!val.equals(label)) continue;
            return val;
        }
        return null;
    }

    public static final EnumSet<SystemScreen> parse(int ... codes) {
        EnumSet<SystemScreen> res = EnumSet.noneOf(SystemScreen.class);
        for (int code : codes) {
            for (SystemScreen val : SystemScreen.values()) {
                if (!val.matches(code)) continue;
                res.add(val);
            }
        }
        return res;
    }
}

