/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone.system;

import android.app.ActivityManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import io.apisense.sting.phone.system.WindowChangeDetectingService;
import java.util.List;
import java.util.TreeMap;

public class TopActivityFinder {
    private Context context;

    public TopActivityFinder(Context context) {
        this.context = context;
    }

    @Nullable
    public String findTopPackage() {
        String currentApp = this.findFromAccessibilityService();
        if (currentApp != null) {
            return currentApp;
        }
        currentApp = Build.VERSION.SDK_INT >= 22 ? this.findFromUsageStats() : this.findFromActivityManager();
        return currentApp;
    }

    @Nullable
    private String findFromAccessibilityService() {
        return WindowChangeDetectingService.getLastApplication();
    }

    @RequiresApi(api=22)
    @Nullable
    private String findFromUsageStats() {
        long time;
        String currentApp = null;
        UsageStatsManager usm = (UsageStatsManager)this.context.getSystemService("usagestats");
        List appList = usm.queryUsageStats(0, (time = System.currentTimeMillis()) - 1000000L, time);
        if (appList != null && appList.size() > 0) {
            TreeMap<Long, UsageStats> mySortedMap = new TreeMap<Long, UsageStats>();
            for (UsageStats usageStats : appList) {
                mySortedMap.put(usageStats.getLastTimeUsed(), usageStats);
            }
            if (!mySortedMap.isEmpty()) {
                currentApp = ((UsageStats)mySortedMap.get(mySortedMap.lastKey())).getPackageName();
            }
        }
        return currentApp;
    }

    @Nullable
    private String findFromActivityManager() {
        ActivityManager am = (ActivityManager)this.context.getSystemService("activity");
        return ((ActivityManager.RunningTaskInfo)am.getRunningTasks((int)1).get((int)0)).topActivity.getPackageName();
    }
}

