/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone.system;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityEvent;

public class WindowChangeDetectingService
extends AccessibilityService {
    private static final String TAG = "APSWindowChanged";
    private static SparseArray<OnTopWindowChanged> callbacks = new SparseArray();
    private static String lastApplication = null;

    public static void addCallback(OnTopWindowChanged callback) {
        callbacks.put(callback.hashCode(), (Object)callback);
    }

    public static void removeCallback(OnTopWindowChanged callback) {
        callbacks.remove(callback.hashCode());
    }

    public static String getLastApplication() {
        return lastApplication;
    }

    protected void onServiceConnected() {
        super.onServiceConnected();
        AccessibilityServiceInfo config = new AccessibilityServiceInfo();
        config.eventTypes = 32;
        config.feedbackType = 16;
        if (Build.VERSION.SDK_INT >= 16) {
            config.flags = 2;
        }
        this.setServiceInfo(config);
    }

    public void onAccessibilityEvent(AccessibilityEvent event) {
        ComponentName componentName;
        if (event.getEventType() == 32 && event.getPackageName() != null && event.getClassName() != null && this.applicationChanged(componentName = new ComponentName(event.getPackageName().toString(), event.getClassName().toString()))) {
            lastApplication = componentName.getPackageName();
            Log.v((String)TAG, (String)("New top application found: " + lastApplication));
            for (int i = 0; i < callbacks.size(); ++i) {
                ((OnTopWindowChanged)callbacks.valueAt(i)).newTopApplication(lastApplication);
            }
        }
    }

    private boolean applicationChanged(ComponentName componentName) {
        return this.isAnActivity(componentName) && this.applicationsAreDifferent(componentName);
    }

    private boolean applicationsAreDifferent(ComponentName componentName) {
        return lastApplication == null || !lastApplication.equals(componentName.getPackageName());
    }

    private boolean isAnActivity(ComponentName componentName) {
        try {
            return this.getPackageManager().getActivityInfo(componentName, 0) != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public void onInterrupt() {
    }

    public static interface OnTopWindowChanged {
        public void newTopApplication(String var1);
    }
}

