/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.system;

import io.apisense.dart.lib.BitMask;
import java.util.EnumSet;

public enum SystemEvent {
    SCREEN_UNLOCKED("system:screen:unlocked"),
    SCREENSTATE_CHANGED("system:screenState:changed"),
    FOREGROUNDAPP_CHANGED("system:foregroundApp:changed");

    private final int value = 1 << this.ordinal();
    private final String label;

    private SystemEvent(String label) {
        this.label = label;
    }

    public int value() {
        return this.value;
    }

    public final boolean matches(int value) {
        return BitMask.matches((int)this.value, (int)value);
    }

    public final boolean equals(String label) {
        return this.label.equalsIgnoreCase(label);
    }

    public final String toString() {
        return this.label;
    }

    public static final EnumSet<SystemEvent> parse(String ... labels) {
        EnumSet<SystemEvent> res = EnumSet.noneOf(SystemEvent.class);
        for (String label : labels) {
            for (SystemEvent val : SystemEvent.values()) {
                if (!val.equals(label)) continue;
                res.add(val);
            }
        }
        return res;
    }

    public static final EnumSet<SystemEvent> parse(int ... codes) {
        EnumSet<SystemEvent> res = EnumSet.noneOf(SystemEvent.class);
        for (int code : codes) {
            for (SystemEvent val : SystemEvent.values()) {
                if (!val.matches(code)) continue;
                res.add(val);
            }
        }
        return res;
    }
}

